<?php


namespace App\Service\Fees;


use App\Repository\ClassFeeRepository;
use App\Service\DefaultFunction;
use Symfony\Component\HttpFoundation\ParameterBag;

class ClassFeeService {

	/**
	 * @var DefaultFunction
	 */
	private $default_function;
	/**
	 * @var ClassFeeRepository
	 */
	private $class_fee_repository;
	/**
	 * @var StudentFeeService
	 */
	private $student_fee_service;

	public function __construct( DefaultFunction $default_function, ClassFeeRepository $class_fee_repository, StudentFeeService $student_fee_service ) {
		$this->default_function     = $default_function;
		$this->class_fee_repository = $class_fee_repository;
		$this->student_fee_service  = $student_fee_service;
	}


	## validate class fee.
	public function valdiateClassFee( ParameterBag $bag ) {
		$response = [];

		## empty student fee
		if ( empty( $bag->get( 'studentFee' ) ) ) {
			$response = $this->default_function->push_error( $response, $bag->get( 'studentFee' ) );
		}

		## class fee template
		if ( empty( $bag->get( 'classFeeTemplate' ) ) ) {
			$response = $this->default_function->push_error( $response, $bag->get( 'classFeeTemplate' ) );
		}

		## class fee template
		if ( empty( $bag->get( 'class' ) ) ) {
			$response = $this->default_function->push_error( $response, $bag->get( 'class' ) );
		}

		return $response;
	}

	## save data in class fee.
	public function saveClassFee( ParameterBag $bag ) {
		$response = [];

		if ( ! empty( $validationResponse = $this->valdiateClassFee( $bag ) ) ) {
			return $validationResponse;
		}

		## get the fee from student fee table.
		$studentFee = $this->student_fee_service->getFeeFromStudentFeeTable();

		## get the class fee template from the classFeeTemplate table.

		## get the class from the classes table.


		try {
		} catch ( \Exception $exception ) {
			$response = $exception->getMessage();
		}

		return $response;
	}

}