<?php


namespace App\Security;


use App\Entity\User;
use App\Repository\UserRepository;
use App\Service\CustomTokenManager;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Encoder\PasswordEncoderInterface;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Security\Core\Exception\CustomUserMessageAuthenticationException;
use Symfony\Component\Security\Core\Exception\InvalidCsrfTokenException;
use Symfony\Component\Security\Core\Exception\UsernameNotFoundException;

class ApiTokenGenerator
{
    /**
     * @var UserRepository
     */
    private $userRepository;
    /**
     * @var PasswordEncoderInterface
     */
    private $passwordEncoder;
    /**
     * @var CustomTokenManager
     */
    private $customTokenManager;

    /**
     * ApiTokenGenerator constructor.
     * @param UserRepository $userRepository
     * @param CustomTokenManager $customTokenManager
     * @param UserPasswordEncoderInterface $passwordEncoder
     */
    public function __construct(
        UserRepository $userRepository,
        CustomTokenManager $customTokenManager,
        UserPasswordEncoderInterface $passwordEncoder
    ) {
        $this->userRepository = $userRepository;
        $this->passwordEncoder = $passwordEncoder;
        $this->customTokenManager = $customTokenManager;
    }

    public function generateToken(\Symfony\Component\HttpFoundation\Request $request)
    {
        return $this->authenticationPass($request);
    }

    public function authenticationPass(Request $request)
    {
        $generateToken = null;
        $request = $request->request;
        ## for stateless authentication.
        if ($request->get('client_id') <> getenv('APP_CLIENT_ID')) {
            return 'Invalid Client Reference';
        }

        if (filter_var($request->get('authBy'), FILTER_VALIDATE_EMAIL)) {
            ## find user, by email
            $user = $this->userRepository->findOneBy(['email' => $request->get('authBy')]);
        } else {
            ## if not found a user regarding email then we will search by the admission number. $user = $this->userRepository->findOneBy(['admission_number' => $request->get('authBy')]);
        }

        if (!$user instanceof User) {
            ## if still not found a user with the admission number then we will return an exception that user not found
            return 'User not found';
        }


        ## if we found a user then we'll check is user is deleted or not.
        if ($user->getIsDeleted()) {
            ## if user is deleted  then thrown an error.
            return 'User has been deleted, Please contact admin for more details';
        }

        ## if we found a user then we'll check is user is active or not.
        if (!$user->getIsActive()) {
            ## if still not found a user with the admission number then we will return an exception that user not found
            return 'User is deactivated by Admin, Please contact him ';
        }

        $passwordValidation = $this->passwordEncoder->isPasswordValid($user, $request->get('password'));

        if ($passwordValidation) {
            ## if password validate then update the token - api token
            try {
                $generateToken = $this->customTokenManager->saveUpdateApiToken($user, null);
                if (substr($generateToken, 0, 2) == 'OK') {
                    $generateToken = substr($generateToken, 2);
                } else {
                    $generateToken = 'Token is not generated, Please contact Admin';
                }
            } catch (\Exception $exception) {
                $generateToken = $exception->getMessage();
            }
        } else {
            $generateToken = 'Invalid Username/Password';
        }


        return $generateToken;
    }


}
