<?php

namespace App\Repository;

use App\Entity\CustomFields;
use App\Entity\SAnswersRegardingCF;
use App\Entity\User;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method SAnswersRegardingCF|null find( $id, $lockMode = null, $lockVersion = null )
 * @method SAnswersRegardingCF|null findOneBy( array $criteria, array $orderBy = null )
 * @method SAnswersRegardingCF[]    findAll()
 * @method SAnswersRegardingCF[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class SAnswersRegardingCFRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, SAnswersRegardingCF::class );
	}

	public function CustomSearch() {
		$this->createQueryBuilder( 's' )->join( 's.CustomFields', 'custom_fields' )->andWhere( 'custom' );
	}

	/**
	 * @param $fieldId
	 * @param $userId
	 *
	 * This method is used to get the specific field answer based on the speciftc user.
	 *
	 * @return mixed
	 */
	public function getTheFieldAnswer( $fieldId, $userId ) {
		try {
			return $this->createQueryBuilder( 'answer' )
			            ->leftJoin( 'answer.CustomFields', 'custom_fields' )
			            ->leftJoin( 'answer.User', 'user' )
			            ->andWhere( 'user.id = :userId' )
			            ->andWhere( 'custom_fields.id = :fieldId' )
			            ->setParameter( 'fieldId', $fieldId )
			            ->setParameter( 'userId', $userId )
			            ->getQuery()
			            ->getSingleResult();
		} catch ( \Exception $exception ) {
			return $exception->getMessage();
		}
	}

	/*	public function saveRecord( ?User $UserObject,  $FieldAnswer, ?CustomFields $custom_fields ) {
			if ( ! $FieldAnswer || ! $UserObject || $custom_fields ) {
				return 'Given Arguments are not correct';
			}

			$SAnswer = new SAnswersRegardingCF();

			$SAnswer->setUser( $UserObject );
			$SAnswer->setAnswers( $FieldAnswer );

			if ( is_integer( $custom_fields ) ) {
				$this->getEntityManager(CustomFieldsRepository::class)->find()
			} else {
				$SAnswer->setCustomFields();
			}
		}

		// /**
		//  * @return SAnswersRegardingCF[] Returns an array of SAnswersRegardingCF objects
		//  */
	/*
	public function findByExampleField($value)
	{
		return $this->createQueryBuilder('s')
			->andWhere('s.exampleField = :val')
			->setParameter('val', $value)
			->orderBy('s.id', 'ASC')
			->setMaxResults(10)
			->getQuery()
			->getResult()
		;
	}
	*/

	/*
	public function findOneBySomeField($value): ?SAnswersRegardingCF
	{
		return $this->createQueryBuilder('s')
			->andWhere('s.exampleField = :val')
			->setParameter('val', $value)
			->getQuery()
			->getOneOrNullResult()
		;
	}
	*/
}
