<?php

namespace App\Repository;

use App\Entity\ClassSubjectTemplate;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ClassSubjectTemplate|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassSubjectTemplate|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassSubjectTemplate[]    findAll()
 * @method ClassSubjectTemplate[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassSubjectTemplateRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassSubjectTemplate::class);
    }


    ## duplication check
    public function duplicationCheck(ParameterBag $bag)
    {
        $queryBuilder = $this->createQueryBuilder('class_subject_template');

        if (!empty($bag->get('subject_id'))) {
            $queryBuilder->andWhere('class_subject_template.subject__ = :subjectRef')->setParameter('subjectRef', $bag->get('subject_id'));
        }

        if (!empty($bag->get('classTemplate_id'))) {
            $queryBuilder->andWhere('class_subject_template.class_template__ = :classTemplateRef')->setParameter('classTemplateRef', $bag->get('classTemplate_id'));
        }

        $queryBuilder->andWhere('class_subject_template.is_deleted = false');
        $response = $queryBuilder->getQuery()->getResult();

        return $response;

    }

    ## bulk duplication check
    public function bulkDuplicationCheck(array $subjects, int $classTemplateId)
    {

        foreach ($subjects as $key => $value) {
            $bag = new ParameterBag();
            $bag->set('subject_id', $value);
            $bag->set('classTemplate_id', $classTemplateId);
            $response = $this->duplicationCheck($bag);
            if (!empty($response)) {
                unset($subjects[$key]);
            }
        }

        return $subjects;
    }
}
