<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ExamsClassesRepository")
 */
class ExamsClasses
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Exams", inversedBy="examsClasses")
     * @ORM\JoinColumn(nullable=false)
     */
    private $exam;

    /**
     * @ORM\Column(type="datetime")
     */
    private $ec_date;

    /**
     * @ORM\Column(type="time")
     */
    private $exam_start_time;

    /**
     * @ORM\Column(type="time")
     */
    private $exam_end_time;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $exam_location;

    /**
     * @ORM\Column(type="smallint")
     */
    private $exam_total_marks;

    /**
     * @ORM\Column(type="smallint")
     */
    private $exam_passing_marks;

    /**
     * @ORM\Column(type="boolean")
     */
    private $exam_hel;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="examsClasses")
     */
    private $exam_checker;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $exam_marks_entered_at;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Examiners", mappedBy="exams_classes")
     */
    private $examiners;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="examsClasses")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClassesStudent", mappedBy="exams_classes")
     */
    private $examsClassesStudents;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="examsClasses")
     * @ORM\JoinColumn(nullable=false)
     */
    private $ClassSubject;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->examiners = new ArrayCollection();
        $this->examsClassesStudents = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getExam(): ?Exams
    {
        return $this->exam;
    }

    public function setExam(?Exams $exam): self
    {
        $this->exam = $exam;

        return $this;
    }


    public function getEcDate(): ?\DateTimeInterface
    {
        return $this->ec_date;
    }

    public function setEcDate(\DateTimeInterface $ec_date): self
    {
        $this->ec_date = $ec_date;

        return $this;
    }

    public function getExamStartTime(): ?\DateTimeInterface
    {
        return $this->exam_start_time;
    }

    public function setExamStartTime(\DateTimeInterface $exam_start_time): self
    {
        $this->exam_start_time = $exam_start_time;

        return $this;
    }

    public function getExamEndTime(): ?\DateTimeInterface
    {
        return $this->exam_end_time;
    }

    public function setExamEndTime(\DateTimeInterface $exam_end_time): self
    {
        $this->exam_end_time = $exam_end_time;

        return $this;
    }

    public function getExamLocation(): ?string
    {
        return $this->exam_location;
    }

    public function setExamLocation(string $exam_location): self
    {
        $this->exam_location = $exam_location;

        return $this;
    }

    public function getExamTotalMarks(): ?int
    {
        return $this->exam_total_marks;
    }

    public function setExamTotalMarks(int $exam_total_marks): self
    {
        $this->exam_total_marks = $exam_total_marks;

        return $this;
    }

        public function getExamPassingMarks(): ?int
    {
        return $this->exam_passing_marks;
    }

    public function setExamPassingMarks(int $exam_passing_marks): self
    {
        $this->exam_passing_marks = $exam_passing_marks;

        return $this;
    }

    public function getExamHel(): ?bool
    {
        return $this->exam_hel;
    }

    public function setExamHel(bool $exam_hel): self
    {
        $this->exam_hel = $exam_hel;

        return $this;
    }

    public function getExamChecker(): ?User
    {
        return $this->exam_checker;
    }

    public function setExamChecker(?User $exam_checker): self
    {
        $this->exam_checker = $exam_checker;

        return $this;
    }

    public function getExamMarksEnteredAt(): ?\DateTimeInterface
    {
        return $this->exam_marks_entered_at;
    }

    public function setExamMarksEnteredAt(?\DateTimeInterface $exam_marks_entered_at): self
    {
        $this->exam_marks_entered_at = $exam_marks_entered_at;

        return $this;
    }

    /**
     * @return Collection|Examiners[]
     */
    public function getExaminers(): Collection
    {
        return $this->examiners;
    }

    public function addExaminer(Examiners $examiner): self
    {
        if (!$this->examiners->contains($examiner)) {
            $this->examiners[] = $examiner;
            $examiner->setExamsClasses($this);
        }

        return $this;
    }

    public function removeExaminer(Examiners $examiner): self
    {
        if ($this->examiners->contains($examiner)) {
            $this->examiners->removeElement($examiner);
            // set the owning side to null (unless already changed)
            if ($examiner->getExamsClasses() === $this) {
                $examiner->setExamsClasses(null);
            }
        }

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }

    /**
     * @return Collection|ExamsClassesStudent[]
     */
    public function getExamsClassesStudents(): Collection
    {
        return $this->examsClassesStudents;
    }

    public function addExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if (!$this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents[] = $examsClassesStudent;
            $examsClassesStudent->setExamsClasses($this);
        }

        return $this;
    }

    public function removeExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if ($this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents->removeElement($examsClassesStudent);
            // set the owning side to null (unless already changed)
            if ($examsClassesStudent->getExamsClasses() === $this) {
                $examsClassesStudent->setExamsClasses(null);
            }
        }

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->ClassSubject;
    }

    public function setClassSubject(?ClassSubject $ClassSubject): self
    {
        $this->ClassSubject = $ClassSubject;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
