<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassesRepository")
 */
class Classes
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=30, nullable=true)
     */
    private $short_name;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * 0 for the CLass wise attendance and 1 for the subject wise attendance
     */
    private $attendance_type;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $active;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $no_of_students;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Session", inversedBy="classes")
     */
    private $session;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassTemplate", inversedBy="Classes")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class_template;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSubject", mappedBy="classes__", orphanRemoval=true)
     */
    private $classSubject__;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSessionEnrolment", mappedBy="class_session")
     */
    private $classSessionEnrolments;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFee", mappedBy="class")
     */
    private $classFees;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFeeSchedule", mappedBy="class")
     */
    private $classFeeSchedules;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClasses", mappedBy="class")
     */
    private $examsClasses;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClassesStudent", mappedBy="classes")
     */
    private $examsClassesStudents;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\AllocateTeacherToClassAndSubjects", mappedBy="class")
     */
    private $allocateTeacherToClassAndSubjects;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassGrade", mappedBy="class")
     */
    private $classGrades;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * 0 for the CLass wise fee and 1 for the subject wise fee
     */
    private $subjectwise_fee;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTable", mappedBy="class")
     */
    private $classTimeTables;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTableSegments", mappedBy="class")
     */
    private $classTimeTableSegments;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Assesment", mappedBy="assesment_class")
     */
    private $assesments;


    public function __construct()
    {
        //$this->session        = new ArrayCollection();
        $this->classSubject__ = new ArrayCollection();
        $this->classSessionEnrolments = new ArrayCollection();
        $this->classFees = new ArrayCollection();
        $this->classFeeSchedules = new ArrayCollection();
        $this->examsClasses = new ArrayCollection();
        $this->examsClassesStudents = new ArrayCollection();
        $this->allocateTeacherToClassAndSubjects = new ArrayCollection();
        $this->classGrades = new ArrayCollection();
        $this->classTimeTables = new ArrayCollection();
        $this->classTimeTableSegments = new ArrayCollection();
        $this->assesments = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getShortName(): ?string
    {
        return $this->short_name;
    }

    public function setShortName(?string $short_name): self
    {
        $this->short_name = $short_name;

        return $this;
    }

    public function getAttendanceType(): ?int
    {
        return $this->attendance_type;
    }

    public function setAttendanceType(?int $attendance_type): self
    {
        $this->attendance_type = $attendance_type;

        return $this;
    }

    public function getActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(?bool $active): self
    {
        $this->active = $active;

        return $this;
    }

    public function getNoOfStudents(): ?int
    {
        return $this->no_of_students;
    }

    public function setNoOfStudents(?int $no_of_students): self
    {
        $this->no_of_students = $no_of_students;

        return $this;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    /*
     * @deprecated 26-07-2019
     * @return Collection|Session[]
     */
    /*public function getSession(): Collection {
        return $this->session;
    }

    public function addSession( Session $session ): self {
        if ( ! $this->session->contains( $session ) ) {
            $this->session[] = $session;
        }

        return $this;
    }

    public function removeSession( Session $session ): self {
        if ( $this->session->contains( $session ) ) {
            $this->session->removeElement( $session );
        }

        return $this;
    }*/

    public function getClassTemplate(): ?ClassTemplate
    {
        return $this->class_template;
    }

    public function setClassTemplate(?ClassTemplate $class_template): self
    {
        $this->class_template = $class_template;

        return $this;
    }

    /**
     * @return Collection|ClassSubject[]
     */
    public function getClassSubject(): Collection
    {
        return $this->classSubject__;
    }

    public function addClassSubject(ClassSubject $classSubject): self
    {
        if (!$this->classSubject__->contains($classSubject)) {
            $this->classSubject__[] = $classSubject;
            $classSubject->setClasses($this);
        }

        return $this;
    }

    public function removeClassSubject(ClassSubject $classSubject): self
    {
        if ($this->classSubject__->contains($classSubject)) {
            $this->classSubject__->removeElement($classSubject);
            // set the owning side to null (unless already changed)
            if ($classSubject->getClasses() === $this) {
                $classSubject->setClasses(null);
            }
        }

        return $this;
    }

    /**
     * @return mixed
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * @param mixed $session
     */
    public function setSession($session): void
    {
        $this->session = $session;
    }

    /**
     * @return Collection|ClassSessionEnrolment[]
     */
    public function getClassSessionEnrolments(): Collection
    {
        return $this->classSessionEnrolments;
    }

    public function addClassSessionEnrolment(ClassSessionEnrolment $classSessionEnrolment): self
    {
        if (!$this->classSessionEnrolments->contains($classSessionEnrolment)) {
            $this->classSessionEnrolments[] = $classSessionEnrolment;
            $classSessionEnrolment->setClassSession($this);
        }

        return $this;
    }

    public function removeClassSessionEnrolment(ClassSessionEnrolment $classSessionEnrolment): self
    {
        if ($this->classSessionEnrolments->contains($classSessionEnrolment)) {
            $this->classSessionEnrolments->removeElement($classSessionEnrolment);
            // set the owning side to null (unless already changed)
            if ($classSessionEnrolment->getClassSession() === $this) {
                $classSessionEnrolment->setClassSession(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassFee[]
     */
    public function getClassFees(): Collection
    {
        return $this->classFees;
    }

    public function addClassFee(ClassFee $classFee): self
    {
        if (!$this->classFees->contains($classFee)) {
            $this->classFees[] = $classFee;
            $classFee->setClass($this);
        }

        return $this;
    }

    public function removeClassFee(ClassFee $classFee): self
    {
        if ($this->classFees->contains($classFee)) {
            $this->classFees->removeElement($classFee);
            // set the owning side to null (unless already changed)
            if ($classFee->getClass() === $this) {
                $classFee->setClass(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassFeeSchedule[]
     */
    public function getClassFeeSchedules(): Collection
    {
        return $this->classFeeSchedules;
    }

    public function addClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if (!$this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules[] = $classFeeSchedule;
            $classFeeSchedule->setClass($this);
        }

        return $this;
    }

    public function removeClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if ($this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules->removeElement($classFeeSchedule);
            // set the owning side to null (unless already changed)
            if ($classFeeSchedule->getClass() === $this) {
                $classFeeSchedule->setClass(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ExamsClasses[]
     */
    public function getExamsClasses(): Collection
    {
        return $this->examsClasses;
    }

    public function addExamsClass(ExamsClasses $examsClass): self
    {
        if (!$this->examsClasses->contains($examsClass)) {
            $this->examsClasses[] = $examsClass;
            $examsClass->setClass($this);
        }

        return $this;
    }

    public function removeExamsClass(ExamsClasses $examsClass): self
    {
        if ($this->examsClasses->contains($examsClass)) {
            $this->examsClasses->removeElement($examsClass);
            // set the owning side to null (unless already changed)
            if ($examsClass->getClass() === $this) {
                $examsClass->setClass(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ExamsClassesStudent[]
     */
    public function getExamsClassesStudents(): Collection
    {
        return $this->examsClassesStudents;
    }

    public function addExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if (!$this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents[] = $examsClassesStudent;
            $examsClassesStudent->setClasses($this);
        }

        return $this;
    }

    public function removeExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if ($this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents->removeElement($examsClassesStudent);
            // set the owning side to null (unless already changed)
            if ($examsClassesStudent->getClasses() === $this) {
                $examsClassesStudent->setClasses(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    /**
     * @return Collection|AllocateTeacherToClassAndSubjects[]
     */
    public function getAllocateTeacherToClassAndSubjects(): Collection
    {
        return $this->allocateTeacherToClassAndSubjects;
    }

    public function addAllocateTeacherToClassAndSubject(
        AllocateTeacherToClassAndSubjects $allocateTeacherToClassAndSubject
    ): self {
        if (!$this->allocateTeacherToClassAndSubjects->contains($allocateTeacherToClassAndSubject)) {
            $this->allocateTeacherToClassAndSubjects[] = $allocateTeacherToClassAndSubject;
            $allocateTeacherToClassAndSubject->setClass($this);
        }

        return $this;
    }

    public function removeAllocateTeacherToClassAndSubject(
        AllocateTeacherToClassAndSubjects $allocateTeacherToClassAndSubject
    ): self {
        if ($this->allocateTeacherToClassAndSubjects->contains($allocateTeacherToClassAndSubject)) {
            $this->allocateTeacherToClassAndSubjects->removeElement($allocateTeacherToClassAndSubject);
            // set the owning side to null (unless already changed)
            if ($allocateTeacherToClassAndSubject->getClass() === $this) {
                $allocateTeacherToClassAndSubject->setClass(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassGrade[]
     */
    public function getClassGrades(): Collection
    {
        return $this->classGrades;
    }

    public function addClassGrade(ClassGrade $classGrade): self
    {
        if (!$this->classGrades->contains($classGrade)) {
            $this->classGrades[] = $classGrade;
            $classGrade->setClass($this);
        }

        return $this;
    }

    public function removeClassGrade(ClassGrade $classGrade): self
    {
        if ($this->classGrades->contains($classGrade)) {
            $this->classGrades->removeElement($classGrade);
            // set the owning side to null (unless already changed)
            if ($classGrade->getClass() === $this) {
                $classGrade->setClass(null);
            }
        }

        return $this;
    }

    public function getSubjectwiseFee(): ?bool
    {
        return $this->subjectwise_fee;
    }

    public function setSubjectwiseFee(?bool $subjectwise_fee): self
    {
        $this->subjectwise_fee = $subjectwise_fee;

        return $this;
    }

    /**
     * @return Collection|ClassTimeTable[]
     */
    public function getClassTimeTables(): Collection
    {
        return $this->classTimeTables;
    }

    public function addClassTimeTable(ClassTimeTable $classTimeTable): self
    {
        if (!$this->classTimeTables->contains($classTimeTable)) {
            $this->classTimeTables[] = $classTimeTable;
            $classTimeTable->setClass($this);
        }

        return $this;
    }

    public function removeClassTimeTable(ClassTimeTable $classTimeTable): self
    {
        if ($this->classTimeTables->contains($classTimeTable)) {
            $this->classTimeTables->removeElement($classTimeTable);
            // set the owning side to null (unless already changed)
            if ($classTimeTable->getClass() === $this) {
                $classTimeTable->setClass(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassTimeTableSegments[]
     */
    public function getClassTimeTableSegments(): Collection
    {
        return $this->classTimeTableSegments;
    }

    public function addClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if (!$this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments[] = $classTimeTableSegment;
            $classTimeTableSegment->setClass($this);
        }

        return $this;
    }

    public function removeClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if ($this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments->removeElement($classTimeTableSegment);
            // set the owning side to null (unless already changed)
            if ($classTimeTableSegment->getClass() === $this) {
                $classTimeTableSegment->setClass(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Assesment[]
     */
    public function getAssesments(): Collection
    {
        return $this->assesments;
    }

    public function addAssesment(Assesment $assesment): self
    {
        if (!$this->assesments->contains($assesment)) {
            $this->assesments[] = $assesment;
            $assesment->setAssesmentClass($this);
        }

        return $this;
    }

    public function removeAssesment(Assesment $assesment): self
    {
        if ($this->assesments->contains($assesment)) {
            $this->assesments->removeElement($assesment);
            // set the owning side to null (unless already changed)
            if ($assesment->getAssesmentClass() === $this) {
                $assesment->setAssesmentClass(null);
            }
        }

        return $this;
    }


}
