<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassSubjectTemplateRepository")
 */
class ClassSubjectTemplate
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $marks;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $pass_marks;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassTemplate", inversedBy="classSubjectTemplates")
     */
    private $class_template__;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Subjects", inversedBy="classSubjectTemplates")
     * @ORM\JoinColumn(nullable=false)
     */
    private $subject__;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;

    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    private $subject_name;

    /**
     * @ORM\Column(type="string", length=30, nullable=true)
     */
    private $short_name;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $credits;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $hidden;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSubject", mappedBy="class_subject_template__")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $classSubjects;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->subject_template = new ArrayCollection();
//        $this->class_template = new ArrayCollection();
        $this->classSubjectTemplates = new ArrayCollection();
        $this->classSubjects = new ArrayCollection();
        $this->class_template__ = new ArrayCollection();
    }


    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMarks(): ?float
    {
        return $this->marks;
    }

    public function setMarks(?float $marks): self
    {
        $this->marks = $marks;

        return $this;
    }

    public function getPassMarks(): ?int
    {
        return $this->pass_marks;
    }

    public function setPassMarks(?int $pass_marks): self
    {
        $this->pass_marks = $pass_marks;

        return $this;
    }

    public function getSubject(): ?subjects
    {
        return $this->subject__;
    }

    public function setSubject(subjects $subject): self
    {
        $this->subject__ = $subject;

        return $this;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getSubjectName(): ?string
    {
        return $this->subject_name;
    }

    public function setSubjectName(?string $subject_name): self
    {
        $this->subject_name = $subject_name;

        return $this;
    }

    public function getShortName(): ?string
    {
        return $this->short_name;
    }

    public function setShortName(?string $short_name): self
    {
        $this->short_name = $short_name;

        return $this;
    }

    public function getCredits(): ?int
    {
        return $this->credits;
    }

    public function setCredits(?int $credits): self
    {
        $this->credits = $credits;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getClassTemplate(): self
    {
        return $this->class_template__;
    }

    /**
     * @param mixed $class_template__
     */
    public function setClassTemplate($class_template__): void
    {
        $this->class_template__ = $class_template__;
    }

    public function getHidden(): ?bool
    {
        return $this->hidden;
    }

    public function setHidden(?bool $hidden): self
    {
        $this->hidden = $hidden;

        return $this;
    }

    /**
     * @return Collection|ClassSubject[]
     */
    public function getClassSubjects(): Collection
    {
        return $this->classSubjects;
    }

    public function addClassSubject(ClassSubject $classSubject): self
    {
        if (!$this->classSubjects->contains($classSubject)) {
            $this->classSubjects[] = $classSubject;
            $classSubject->setClassSubjectTemplate($this);
        }

        return $this;
    }

    public function removeClassSubject(ClassSubject $classSubject): self
    {
        if ($this->classSubjects->contains($classSubject)) {
            $this->classSubjects->removeElement($classSubject);
            // set the owning side to null (unless already changed)
            if ($classSubject->getClassSubjectTemplate() === $this) {
                $classSubject->setClassSubjectTemplate(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

}
