<?php

namespace App\Controller;

use App\Entity\ClassGrade;
use App\Entity\ClassSubject;
use App\Entity\ClassSubjectTemplate;
use App\Entity\ClassTemplate;

use App\Entity\Guardian;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeTemplateRepository;
use App\Repository\ClassSubjectRepository;
use App\Repository\ClassSubjectTemplateRepository;
use App\Repository\ClassTemplateRepository;
use App\Repository\SessionRepository;
use App\Repository\StudentFeeRepository;
use App\Repository\SubjectsRepository;
use App\Repository\UserRepository;
use App\Service\DefaultFunction;
use App\Service\StudentClasses;
use App\Service\Students\Grade\ClassGradeService;
use App\Service\Students\Grade\ClassGradeTemplateService;
use App\Service\Students\Grade\GradeBase;
use App\Service\Students\Grade\GradeCategoriesService;
use App\Service\StudentsEnrollment\Enrollments;
use App\Service\StudentSession;
use App\Service\SubjectService;
use Doctrine\ORM\EntityManagerInterface;
use Nzo\UrlEncryptorBundle\Annotations\ParamDecryptor;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class ClassController extends AbstractController
{

    /**
     * @var ClassTemplateRepository
     */
    private $class_template_repository;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var SubjectsRepository
     */
    private $subjects_repository;
    /**
     * @var StudentClasses
     */
    private $student_classes;
    /**
     * @var ClassSubjectTemplateRepository
     */
    private $class_subject_template_repository;
    /**
     * @var SubjectService
     */
    private $subject_service;
    /**
     * @var ClassSubjectRepository
     */
    private $class_subject_repository;
    /**
     * @var StudentFeeRepository
     */
    private $student_fee_repository;
    /**
     * @var ClassFeeTemplateRepository
     */
    private $class_fee_template_repository;
    /**
     * @var Enrollments
     */
    private $enrollments;
    /**
     * @var SessionRepository
     */
    private $session_repository;
    /**
     * @var StudentSession
     */
    private $student_session;
    /**
     * @var UserRepository
     */
    private $userRepository;

    public function __construct(
        StudentSession $student_session,
        SessionRepository $session_repository,
        Enrollments $enrollments,
        ClassTemplateRepository $class_template_repository,
        ClassFeeTemplateRepository $class_fee_template_repository,
        ClassesRepository $classes_repository,
        SubjectsRepository $subjects_repository,
        StudentClasses $student_classes,
        ClassSubjectTemplateRepository $class_subject_template_repository,
        SubjectService $subject_service,
        ClassSubjectRepository $class_subject_repository,
        StudentFeeRepository $student_fee_repository,
        UserRepository $userRepository
    ) {
        $this->class_template_repository = $class_template_repository;
        $this->classes_repository = $classes_repository;
        $this->subjects_repository = $subjects_repository;
        $this->student_classes = $student_classes;
        $this->class_subject_template_repository = $class_subject_template_repository;
        $this->subject_service = $subject_service;
        $this->class_subject_repository = $class_subject_repository;
        $this->student_fee_repository = $student_fee_repository;
        $this->class_fee_template_repository = $class_fee_template_repository;
        $this->enrollments = $enrollments;
        $this->session_repository = $session_repository;
        $this->student_session = $student_session;
        $this->userRepository = $userRepository;
    }

    /**
     * @Route("{_locale}/class", name="class")
     *
     * Purpose: Display list of the class
     */
    public function index()
    {
        return $this->render(
            'class/index.html.twig',
            [
                'classList' => $this->student_classes->getAllClassTemplate(),
            ]
        );
    }

    /**
     * @Route("{_locale}/class/add/{query}", name="add_class", defaults={"query"=null})
     *
     * Purpose: used to add or update class
     *
     * @param $query
     * @param GradeBase $gradeBase
     * @return Response
     * @ParamDecryptor(params={"query"})
     */
    public function addClass($query, GradeBase $gradeBase)
    {
        $classTemplate = new ClassTemplate();
        ## if we found something in the query
        if ($query) {
            try {
                ## get the session.
                $classTemplate = $this->class_template_repository->find($query);
                ## if found no record against the id then create new empty session
                if (!$classTemplate instanceof ClassTemplate) {
                    $classTemplate = new ClassTemplate();
                }
            } catch (\Exception $exception) {

            }
        }

        return $this->render(
            'class/addEditClassTemplate.html.twig',
            [
                'classTemplate' => $classTemplate,
                'subjectList' => $this->subjects_repository->findAllNonDeleted(),
                'feeList' => $this->student_fee_repository->findAllNonDeleted(),
                'classFeeTemplate' => $this->class_fee_template_repository->findBy(
                    ['class_template' => $classTemplate->getId()]
                ),
                'session' => $this->session_repository->findBy(['active' => true]),
                'gradeCategory' => $gradeBase->getGradeCategories(),
            ]
        );
    }

    /**
     * @Route("{_locale}/classes", name="classes")
     * Purpose: Display list of the classes
     * @param Request $request
     * @return Response
     */
    public function classesList(Request $request)
    {
        return $this->render(
            'class/classes.html.twig',
            [
                'sessions' => $this->student_session->getAllSessions(),
                'classes' => $this->student_classes->getAllClasses($request->query),
            ]
        );
    }

    /**
     * @Route("{_locale}/class-grades", name="class_grades")
     * Purpose: Display list of all classes Grade
     * @param Request $request
     * @param ClassGradeService $classGradeService
     * @return Response
     */
    public function classGrade(Request $request, ClassGradeService $classGradeService)
    {
        return $this->render(
            'app_settings/grades/class/listOfClassGrades.html.twig',
            [
                'sessions' => $this->student_session->getAllSessions(),
                'classes' => $this->student_classes->getAllClasses($request->query),
                'class_grades' => $classGradeService->listOfClassGrade($request->query),
            ]
        );
    }

    /**
     * @Route("{_locale}/class/requestHandler/{query}", name="requestHandler_student_class")
     * @param Request $request
     * @param ClassGradeService $classGradeService
     * @param null $query
     *
     * @return JsonResponse
     */
    public function ajaxHandler(Request $request, ClassGradeService $classGradeService, $query = null)
    {
        ## if user is not logged in the redirect th e user to login page.
        $response = 'OK';

        if (empty($query)) {
            ## get the query variable from the get request.
            $query = $request->query->get('query');
        }

        switch ($query) {
            case 'addClass':
                ## add edit classTemplate
                $response = $this->student_classes->saveClasses(
                    $request->request,
                    $this->student_session,
                    $classGradeService
                );
                break;
            case 'getSubjectForm':
                ## server class_subject_template form
                $response = 'escape__fromErro_'.$this->serve__subjectForm(
                        $request->request->get('ref'),
                        $request->request->get('className')
                    );
                break;
            case 'getSubjectForm__forClassSubjectTable':
                ## server class_subject_template form
                $response = 'escape__fromErro_'.$this->serve__subjectFormOfClassSubjectTable(
                        $request->request->get('ref__'),
                        $request->request->get('show')
                    );
                break;
            case 'updateSubjectForm__forClassSubjectTable':
                ## server class_subject_template form
                $response = $this->student_classes->saveClassSubject($request->request);
                break;
            case 'update____class_subject_template':
                ## update class subject
                $response = $this->subject_service->update__classSubjectTemplate($request->request);
                break;
            case 'getTheSubjectsOfClassFromClassEnrolment':
                ## get records from classSessionEnrolment su    bject for edit purposes.
                $Bag = new ParameterBag();
                $Bag->set('referece_', $request->request->get('fromClassRef'));
                $response = $this->enrollments->get__class_session_enrolment(
                    (int)$request->request->get('fromClassSessionEnrolment')
                );
                $response = 'escape__fromErro_'.$this->renderView(
                        'student/Enrolments/editEnrolment.html.twig',
                        [
                            'classSessionEnrolment' => $response,
                            'classAssociatedSubject' => $this->subject_service->get__subjectsFromClassSubjectTable(
                                $Bag
                            ),
                        ]
                    );
                break;
            case 'dces':
                ## delete student enrolment in subjects.
                $response = $this->subject_service->deleteStudentEnrolmentInSubject(
                    (int)$request->request->get('CSES'),
                    $this->enrollments
                );
                break;
            case 'dce':
                ## delete student enrolment in Classes.
                $response = $this->student_classes->deleteStudentClassEnrolment(
                    (int)$request->request->get('CSE'),
                    $this->enrollments
                );
                break;
            case 'dCT':
                ## delete class template
                $response = $this->student_classes->deleteClassTemplate((int)$request->request->get('rOO'), true);
                break;
            case 'dClasses':
                ## delete classes
                $response = $this->student_classes->deleteClasses((int)$request->request->get('rOO'), true);
                break;
        }

        return new JsonResponse($response, 200);
    }

    /**
     * @param $subjectId
     * @param null $className
     * @return string
     *
     *  ## we're using two type of class,
     * ## 1. Class_template
     * ## 2. Class
     * ## all major methods are serving class_template table.
     */
    protected function serve__subjectForm($subjectId, $className = null)
    {

        $Subjects = new ClassSubjectTemplate();
        try {
            $Subjects = $this->class_subject_template_repository->find($subjectId);
            if (!$Subjects instanceof ClassSubjectTemplate) {
                $Subjects = new ClassSubjectTemplate();
            }
        } catch (\Exception $exception) {
        }

        return $this->renderView(
            'subject/editClassSubjectTemplate.html.twig',
            [
                'subjectForEdit' => $Subjects,
                'className' => $className,
            ]
        );
    }

    /**
     * @param $subjectId
     * @param $showSection
     * @return string
     * ## Serve data from the class subject table
     */
    protected function serve__subjectFormOfClassSubjectTable($subjectId, $showSection)
    {

        $Subjects = new ClassSubject();
        try {
            $Subjects = $this->class_subject_repository->find($subjectId);
            if (!$Subjects instanceof ClassSubject) {
                $Subjects = new ClassSubject();
            }
        } catch (\Exception $exception) {
        }

        $view = 'subject/editClassSubjectTemplate.html.twig';
        if ($showSection == 'teacherAllocation') {
            $view = 'teacher/assignTeacherToSubject.html.twig';
        }

        return $this->renderView(
            $view,
            [
                'subjectForEdit' => $Subjects,
                'className' => '',
                'teacherList' => $this->userRepository->findBy(['category' => 't', 'is_deleted' => 0]),
            ]
        );
    }

}
