<?php

namespace App\Repository;

use App\Entity\ScheduleMessage;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ScheduleMessage|null find( $id, $lockMode = null, $lockVersion = null )
 * @method ScheduleMessage|null findOneBy( array $criteria, array $orderBy = null )
 * @method ScheduleMessage[]    findAll()
 * @method ScheduleMessage[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class ScheduleMessageRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, ScheduleMessage::class );
	}

	public function advanceSearch( ParameterBag $bag ) {
		$queryBuilder = $this->createQueryBuilder( 'schedule_messages' );

		## get not sent messages
		if ( ! empty( $bag->get( 'not_sent' ) ) ) {
			$queryBuilder->andWhere( 'schedule_messages.is_sent', false );
		}

		## get the sent messages
		if ( ! empty( $bag->get( 'sent' ) ) ) {
			$queryBuilder->andWhere( 'schedule_messages.is_sent', true );
		}

		## sent Datetime
		if ( ! empty( $bag->get( 'sent_dateTime' ) ) ) {
			if ( ! empty( $bag->get( 'equality' ) ) ) {
				$operator = ' like ';
			} else {
				$operator = ' < ';
			}
			$queryBuilder->andWhere( 'schedule_messages.sent_datetime ' . $operator . ' :sentDateTime' )
			             ->setParameter( 'sentDateTime', $bag->get( 'sent_dateTime' ) );
		}
		return $queryBuilder->getQuery()->getResult();
	}
}
