<?php

namespace App\Controller;

use App\Entity\Classes;
use App\Entity\ClassSubject;
use App\Entity\ClassSubjectTemplate;
use App\Entity\Session;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeRepository;
use App\Repository\ClassFeeTemplateRepository;
use App\Repository\ClassTemplateRepository;
use App\Repository\SessionRepository;
use App\Repository\StudentFeeRepository;
use App\Repository\UserRepository;
use App\Service\ApiHelpers;
use App\Service\Fees\StudentFeeService;
use App\Service\StudentClasses;
use App\Service\Students\Grade\ClassGradeService;
use App\Service\StudentSession;
use App\Service\SubjectService;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use Nzo\UrlEncryptorBundle\Annotations\ParamDecryptor;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 *
 * */
class SessionController extends AbstractController
{

    /**
     * @var SessionRepository
     */
    private $session_repository;
    /**
     * @var ClassTemplateRepository
     */
    private $class_template_repository;
    /**
     * @var StudentSession
     */
    private $student_session;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var StudentClasses
     */
    private $student_classes_service;
    /**
     * @var ApiHelpers
     */
    private $api_helpers;
    private $student_fee_repository;
    /**
     * @var ClassFeeTemplateRepository
     */
    private $class_fee_template_repository;
    /**
     * @var ClassFeeRepository
     */
    private $class_fee_repository;
    /**
     * @var StudentFeeService
     */
    private $student_fee_service;
    /**
     * @var UserRepository
     */
    private $userRepository;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;
    /**
     * @var SubjectService
     */
    private $subjectService;

    public function __construct(
        StudentFeeService $student_fee_service,
        SessionRepository $session_repository,
        ClassFeeTemplateRepository $class_fee_template_repository,
        StudentFeeRepository $student_fee_repository,
        ClassTemplateRepository $class_template_repository,
        StudentSession $student_session,
        ClassesRepository $classes_repository,
        StudentClasses $student_classes_service,
        ApiHelpers $api_helpers,
        ClassFeeRepository $class_fee_repository,
        UserRepository $userRepository,
        EntityManagerInterface $entityManager,
        SubjectService $subjectService
    ) {
        $this->session_repository = $session_repository;
        $this->class_template_repository = $class_template_repository;
        $this->student_session = $student_session;
        $this->classes_repository = $classes_repository;
        $this->student_classes_service = $student_classes_service;
        $this->api_helpers = $api_helpers;
        $this->student_fee_repository = $student_fee_repository;
        $this->class_fee_template_repository = $class_fee_template_repository;
        $this->class_fee_repository = $class_fee_repository;
        $this->student_fee_service = $student_fee_service;
        $this->userRepository = $userRepository;
        $this->entityManager = $entityManager;
        $this->subjectService = $subjectService;
    }

    /**
     * @Route("{_locale}/session", name="session")
     */
    public function index()
    {
        return $this->render(
            'session/index.html.twig',
            [
                'sessionList' => $this->student_session->getAllSessions(),
            ]
        );
    }


    /**
     * @Route("{_locale}/session/add/{query}", name="add_session", defaults={"query"=null})
     * @param $query
     * @ParamDecryptor(params={"query"})
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function add_session($query)
    {
        $session = new Session();

        ## if we found something in the query
        if ($query) {
            try {
                ## get the session.
                $session = $this->session_repository->find($query);
                ## if found no record against the id then create new empty session
                if (!$session instanceof Session) {
                    $session = new Session();
                }
            } catch (\Exception $exception) {

            }
        }

        return $this->render(
            'session/addSession.html.twig',
            [
                'session' => $session,
                'classList' => $this->class_template_repository->findAllNonDeleted(),
            ]
        );
    }


    ## we're using two type of class,
    ## 1. Class_template
    ## 2. Class
    ## all major methods are serving class_template table.
    protected function serve__classForm($classId, $showSection = null)
    {

        $Class = new Classes();
        try {
            $Class = $this->classes_repository->find($classId);
            if (!$Class instanceof Classes) {
                $Class = new Classes();
            }
        } catch (\Exception $exception) {
        }

        ## get the related subject from the class_subject table.
        $RelatedSubject = $Class->getClassSubject()->toArray();
        if (empty($RelatedSubject)) {
            $RelatedSubject = [];
        }

        $view = 'class/editClass.html.twig';
        if ($showSection == 'teacherAllocation') {
            $view = 'teacher/assignTeacherToClass.html.twig';
        }


        return $this->renderView(
            $view,
            [
                'class' => $Class,
                'relatedSubject' => $RelatedSubject,
                'student_fee' => $this->entityManager->getRepository('App:StudentFee')->findAll(),
                'grades_categories' => $this->entityManager->getRepository('App:GradeCategories')->findAll(),
                'subjects' => $this->subjectService->listOfSubjects(),
                'attached_fee_list_with__classes' => $this->student_fee_service->getFeeFromClassFeeTable(
                    null,
                    'class',
                    $Class->getId()
                ),
                'teacherList' => $this->userRepository->findBy(['category' => 't', 'is_deleted' => 0]),
                'showOnly' => $showSection,
            ]
        );
    }


    /**
     * @Route("{_locale}/session/requestHandler/{query}", name="requestHandler_student_session")
     * @param Request $request
     * @param ClassGradeService $classGradeService
     * @param null $query
     *
     * @return JsonResponse
     */
    public function ajaxHandler(Request $request, ClassGradeService $classGradeService, $query = null)
    {
        ## if user is not logged in the redirect th e use rto login page.
        $response = 'OK';

        if (empty($query)) {
            ## get the query variable from the get request.
            $query = $request->query->get('query');
        }

        switch ($query) {
            case 'addSection':
                ## active & de-active request.
                $response = $this->student_session->saveSession($request->request, $classGradeService);
                break;
            case 'getClassForm':
                $response = 'escape__fromErro_'.$this->serve__classForm(
                        $request->request->get('ref'),
                        $request->request->get('show')
                    );
                break;
            case 'updateClasses__':
                ## Update Classes
                $response = $this->student_classes_service->updateClasses__($request->request);
                break;
            case 'DS':
                ## delete session
                $response = $this->student_session->deleteSession((int)$request->request->get('rOO'));
                break;
        }

        return new JsonResponse($response, 200);
    }
}
