<?php

/*
 * IMPROVEMENTS:
 * 1. "custom_fields_repository method calls two times in the registration process."
 * 2. If email already exits then drop current, user's email
 * 3. $request->files is using two times loop, 1 for validate 2 for saving..
 * User Registration process is used same method twice.. so please remove that late.
 * */

namespace App\Service;


use App\Entity\AAnswerRegardingCF;
use App\Entity\CustomFields;
use App\Entity\Guardian;
use App\Entity\SAnswersRegardingCF;
use App\Entity\TAnswerRegardingCF;
use App\Entity\User;
use App\Repository\AAnswerRegardingCFRepository;
use App\Repository\CustomFieldsRepository;
use App\Repository\SAnswersRegardingCFRepository;
use App\Repository\TAnswerRegardingCFRepository;
use App\Repository\UserRepository;
use App\Repository\WhoCanUpdateCustomFieldRepository;
use App\Service\Guardian\GuardianService;
use Doctrine\ORM\EntityManager;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\Router;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Security\Core\Exception\InvalidCsrfTokenException;
use Symfony\Component\Security\Csrf\CsrfToken;
use Symfony\Component\Security\Csrf\CsrfTokenManager;

class UserRegistration
{


    /**
     * @var UserPasswordEncoderInterface
     */
    private $user_password_encoder;
    /**
     * @var EntityManager $this ->DoctrineManger
     */
    private $DoctrineManger;
    /**
     * @var CustomFieldsRepository
     */
    private $custom_fields_repository;
    /**
     * @var Router
     */
    private $router;
    /**
     * @var CsrfTokenManager
     */
    private $csrf_token_manager;

    const FlashMessageString = 'userRegistrationError';
    /**
     * @var Session
     */
    private $session;
    /*
     * User category
     * */
    const UserCategories = [
        'a',
        't',
        's',
    ];
    /**
     * @var FileManagment
     */
    private $file_managment;

    private $errorArray = [];
    /**
     * @var TriggerNotifications
     */
    private $trigger_notifications;
    /**
     * @var CustomFields
     */
    private $custom_fields;
    /**
     * @var SAnswersRegardingCFRepository
     */
    private $s_answers_regarding_CF_repository;
    /**
     * @var AAnswerRegardingCFRepository
     */
    private $a_answer_regarding_CF_repository;
    /**
     * @var TAnswerRegardingCFRepository
     */
    private $t_answer_regarding_CF_repository;
    /**
     * @var UserRepository
     */
    private $user_repository;
    /**
     * @var WhoCanUpdateCustomFieldRepository
     */
    private $who_can_update_custom_field_repository;
    /**
     * @var GuardianService
     */
    private $guardian_service;


    public function __construct(
        EntityManager $entity_manager,
        RouterInterface $router,
        CsrfTokenManager $csrf_token_manager,
        SessionInterface $session,
        UserPasswordEncoderInterface $user_password_encoder,
        CustomFieldsRepository $custom_fields_repository,
        FileManagment $file_managment,
        TriggerNotifications $trigger_notifications,
        SAnswersRegardingCFRepository $s_answers_regarding_CF_repository,
        AAnswerRegardingCFRepository $a_answer_regarding_CF_repository,
        TAnswerRegardingCFRepository $t_answer_regarding_CF_repository,
        UserRepository $user_repository,
        WhoCanUpdateCustomFieldRepository $who_can_update_custom_field_repository,
        GuardianService $guardian_service
    ) {
        $this->user_password_encoder = $user_password_encoder;
        $this->DoctrineManger = $entity_manager;
        $this->custom_fields_repository = $custom_fields_repository;
        $this->router = $router;
        $this->csrf_token_manager = $csrf_token_manager;
        $this->session = $session;
        $this->file_managment = $file_managment;
        $this->trigger_notifications = $trigger_notifications;
        //	$this->custom_fields            = $custom_fields;
        $this->s_answers_regarding_CF_repository = $s_answers_regarding_CF_repository;
        $this->a_answer_regarding_CF_repository = $a_answer_regarding_CF_repository;
        $this->t_answer_regarding_CF_repository = $t_answer_regarding_CF_repository;
        $this->user_repository = $user_repository;
        $this->who_can_update_custom_field_repository = $who_can_update_custom_field_repository;
        $this->guardian_service = $guardian_service;
    }


    /**
     * @param $request
     * @return string|array
     */
    public function registerUser($request)
    {
        $returnAr = [];
        /**
         * @var ParameterBag $postData
         * */
        $postData = $request->request;

        ## ignore csrf token
        if ($postData->get('ignoreCsrfToken') <> 'true09Application') {
            ## validate CSRF Token
            $token = new CsrfToken(getenv('APP_SECRET'), $postData->get('_token_csrf_'));
            if (!$this->csrf_token_manager->isTokenValid($token)) {
                throw new InvalidCsrfTokenException();
            }
            ## if token is validate then remove value from the array.
            $postData->remove('_token_csrf_');
        }

        ## session to save the flash messages.
        $session = new Session();
        $this->session->getFlashBag()->get(self::FlashMessageString);

        ## Implement form validation.
        if (empty($postData->get('category')) || !in_array($postData->get('category'), self::UserCategories)) {
            ## if category is empty then save is as student.
            ## or if category is not a , s and t then also save student
            $postData->set('category', 's');
        }

        ## if first name is missing.
        if (empty($postData->get('fName'))) {
            ## push error in the array
            array_push($returnAr, 'Please type your first name!');
        }

        ## if last name is missing.
        if (empty($postData->get('lName'))) {
            ## push errors in the array.
            array_push($returnAr, 'Please type your last name!');
        }

        ## if password is missing.
        if (empty($postData->get('password'))) {
            ## push errors in the array.
            array_push($returnAr, 'Please type a secret / password!');
        }

        ## if gender is missing.
        if (empty($postData->get('gender'))) {
            ##push errors in the array
            array_push($returnAr, 'Please select your gender');
        }

        if (!filter_var($postData->get('email'), FILTER_VALIDATE_EMAIL)) {
            ## invalid email address
            array_push($returnAr, 'Invalid email address');
        }

        ## email validation - check if email of this is user is already exits or not.
        if (!empty($this->user_repository->findBy(['email' => $postData->get('email')]))) {
            ##push errors in the array
            array_push($returnAr, $postData->get('email').' , is already register with the other user');
        }


        ## sort field according to custom field ID.
        ## separate custom fields from the other fields.
        ## this is only checking POST array.
        foreach ($postData as $key => $value) {

            ## find an array keys which has _ character.
            ## radio and checkbox field having this situation.
            ## i''ve did these because these fields will have multiple options so I need to insert them in the string form.
            if (strpos($key, '_')) {

                ## if we found an _ character then make it array and extract the custom field id
                ## first element of array will be the id of custom field.
                ## second element of array will be the type of the field.
                $temp_ar = explode('_', $key);

                ## if field type is radio then get the single value.
                if ($temp_ar[1] == 'radio') {

                    ## this trick is used to sent data to the server .
                    ## if checkbox and radio buttons are uncheck then they don't submit to server, so, In case of validation we will miss out this scenrio
                    ## so, to send every input field to the server I've create an hidden checkbox and radio button which will be checked then that field data sent to the server.
                    ## server validate that field, Is we require or not require that.

                    if (array_search('__ignore___', $value)) {
                        ## remove then default checked value.
                        unset($value [array_search('__ignore___', $value)]);
                    }

                    ## add to the array.
                    $temp_ar2 = [$temp_ar[0] => '**radio***'.implode(',', $value)];
                    $postData->add($temp_ar2);

                } else {
                    if ($temp_ar[1] == 'checkbox') {

                        ## remove then default checked value.
                        if (array_search('__ignore___', $value)) {
                            unset($value [array_search('__ignore___', $value)]);
                        }

                        ## add to the array.
                        $temp_ar2 = [$temp_ar[0] => '**checkbox***'.implode(',', $value)];
                        $postData->add($temp_ar2);
                    }
                }

                ## validate a field is this field is require or not.
                $this->validateCustomFields($temp_ar[0], $value);

                ## remove that key which've underscore.
                $postData->remove($key);

            } else {
                if (is_integer($key)) {

                    ## these are normal fields means will have no multiple answers., text field,
                    $this->validateCustomFields($key, $value);
                }
            }
        }

        ## Validating $_FILES array.
        if (!empty($request->files)) {
            ## if user selected some files to upload
            foreach ($request->files as $key => $value) {

                /** @var CustomFields $customFieldObject */
                $customFieldObject = $this->custom_fields_repository->find($key);

                ## if empty and required.
                if ($customFieldObject->getis_require() && empty($value)) {
                    array_push($returnAr, 'Please upload, '.$customFieldObject->getlabel());
                }

                ## validate allowed extensions.
                if (!empty($value)) {
                    $allowedExtensions = explode(',', $customFieldObject->getAllowedExtension());


                    try {
                        if (!in_array($value->guessExtension(), $allowedExtensions)) {
                            array_push(
                                $returnAr,
                                'This file extension is not allowed, Allowed extension are '.$customFieldObject->getAllowedExtension(
                                )
                            );
                        }
                    } catch (\Exception $exception) {
                        array_push($returnAr, $exception->getMessage());
                    }
                }
            }
        }

        ## sent errors if we've it.
        if (!empty($returnAr)) {
            return $returnAr;
        }


        ## save data in the user entity
        $UserEntity = new User();
        $UserEntity->setFName($postData->get('fName'));
        $UserEntity->setLName($postData->get('lName'));
        $UserEntity->setCategory($postData->get('category'));
        $UserEntity->setEmail($postData->get('email'));
        $UserEntity->setGender($postData->get('gender'));
        $UserEntity->setRoles($this->setRoleAccordingToUserCategory($postData->get('category')));
        ## save user's encoded password.
        $UserEntity->setPassword($this->user_password_encoder->encodePassword($UserEntity, $postData->get('password')));

        try {
            ## save user's object to the database.
            $this->DoctrineManger->persist($UserEntity);
            $this->DoctrineManger->flush();
        } catch (\Exception $exception) {
            return $exception->getMessage();
        }

        ## generate the admission number of the student.
        $UserEntity->setAdmissionNumber($UserEntity->getId());

        try {
            ## save admission number to the database.
            $this->DoctrineManger->persist($UserEntity);
            $this->DoctrineManger->flush();
        } catch (\Exception $exception) {
            return $exception->getMessage();
        }

        ## separate custom field from the user's table.
        foreach ($postData as $key => $value) {
            if (empty($value)) {
                continue;
            }

            if (is_numeric($key)) {

                /**
                 * @var CustomFields
                 * */
                $CustomFieldObject = $this->custom_fields_repository->findOneBy(['id' => $key]);

                ## Check where to save custom field data of user.
                ## to do this first, check the user category
                if ($UserEntity->getCategory() == 's') {

                    ## fetch student entity
                    $Entity = new SAnswersRegardingCF();
                    $Entity->setAnswers($value);
                    $Entity->setCustomFields($CustomFieldObject);
                    $Entity->setUser($UserEntity);

                } elseif ($UserEntity->getCategory() == 't') {

                    ## fetch teacher entity
                    $Entity = new TAnswerRegardingCF();
                    $Entity->setAnswers($value);
                    $Entity->setCustomFields($CustomFieldObject);
                    $Entity->setUser($UserEntity);

                } elseif ($UserEntity->getCategory() == 'a') {

                    ## fetch admin entity
                    $Entity = new AAnswerRegardingCF();
                    $Entity->setAnswers($value);
                    $Entity->setCustomFields($CustomFieldObject);
                    $Entity->setUser($UserEntity);
                }


                ## return an error.
                try {
                    ## save answer to the database
                    $this->DoctrineManger->persist($Entity);
                    ## save changes.
                    $this->DoctrineManger->flush();
                } catch (\Exception $exception) {
                    return $exception->getMessage();
                }

            }
        }

        ## file's array.
        ## if files array is not empty
        if (!empty($request->files)) {

            ## upload settings.
            $temp_ar = [
                ## upload privately
                'public' => true,
            ];

            ## run the loop
            foreach ($request->files as $key => $value) {

                /** @var CustomFields $customFieldObject */
                $customFieldObject = $this->custom_fields_repository->find($key);

                ## sent allowed extensions.
                $temp_ar['allowedExtension'] = explode(',', $customFieldObject->getAllowedExtension());
                ## path of the upload file.
                $temp_ar['path'] = 'custom_fields'.DIRECTORY_SEPARATOR.$UserEntity->getId(
                    ).DIRECTORY_SEPARATOR.$key.DIRECTORY_SEPARATOR;
                ## uploaded file.
                $temp_ar['fileArray'] = $value;
                $this->file_managment->uploadFile($temp_ar);
            }
        }

        ## send notification to user, on registration.
        $temp_ar = [
            'event_name' => 'USER_REGISTRATION',
            'user' => $UserEntity,
        ];
        $this->trigger_notifications->triggerNotifications($temp_ar);


        if ($postData->get('returnStudentObject')) {
            $returnAr = $UserEntity;
        } else {
            $returnAr = 'OK';
        }

        ## after successfully register return to the login page.
        return $returnAr;
    }


    /**
     * @param $cateogry
     * @return string
     * ## get user registration route depends on the user's category
     */
    public function getUserRegistrationRouteAccordingToUserCategory($cateogry)
    {
        $cateogry = (string)$cateogry;
        $route = '';
        if ($cateogry == 's') {
            $route = 'student_regisration';
        } elseif ($cateogry == 'a') {
            $route = 'admin_regisration';
        } elseif ($cateogry == 't') {
            $route = 'teacher_registration';
        }

        return $route;
    }

    public function returnData($isError, $userCategory = 's')
    {
        $isError = (bool)$isError;
        $redirectTo = '';
        if ($isError) {
            $redirectTo = $this->router->generate(self::getUserRegistrationRouteAccordingToUserCategory($userCategory));
        } else {
            $redirectTo = $this->router->generate('user_login');
        }

        return new RedirectResponse($redirectTo);
    }

    /**
     * @param int $FieldId
     *
     * @param string $FieldAnswer
     * @param bool|null $checkWhoCanupdate
     * @return bool
     */
    public function validateCustomFields($FieldId, $FieldAnswer, ?bool $checkWhoCanupdate = false)
    {

        $returnValue = 1;

        ## Custom Field Objects.
        $CustomFieldObject = $this->custom_fields_repository->findOneBy(['id' => $FieldId]);

        ## if we found a custom field against the id, of custom field which give by the registration for.
        if ($CustomFieldObject instanceof CustomFields) {
            if ($CustomFieldObject->getis_require() && empty($FieldAnswer)) {
                ## if custom field is require and Field answer is empty then return false , to send back to user
                array_push($this->errorArray, $CustomFieldObject->getlabel().' is require!');
                ## return with the error
                $returnValue = 0;
            }
        }

        return $returnValue;
    }


    /**
     * @return string
     *  Create student gardien password and save into the database.
     */
    public function createGuardianTempFieldsData($whatToCreate, $hint = null)
    {
        $returnData = '';
        if ($whatToCreate == 'name') {
            $returnData = 'G_'.$hint;
        } elseif ($whatToCreate == "password") {
            $returnData = uniqid('_G_');
        }

        return $returnData;
    }

    /**
     * Set user roles when user register..
     * */
    public function setRoleAccordingToUserCategory(?string $category)
    {
        if ($category == 's') {
            $role = ['ROLE_STUDENT'];
        } else {
            if ($category == 't') {
                $role = ['ROLE_TEACHER'];
            } else {
                if ($category == 'a') {
                    $role = ['ROLE_STAFF'];
                }
            }
        }

        return (array)$role;
    }

    ## validate user can edit this custom field or not.
    public function validateUserCanEditCustomFieldOrNot($fieldId, ?int $UserId)
    {
        ## validate if user can edit this field or not.
        $listOfUnEditableFields = $this->who_can_update_custom_field_repository->listOfNonEditableField($UserId);
        if (!empty($listOfUnEditableFields)) {
            ## separate custom field id from the who can edit table.
            $listOfUnEditableFields = array_column($listOfUnEditableFields, 'id');
            ## check given value is in the array or not.
            if (in_array($fieldId, $listOfUnEditableFields)) {
                array_push($this->errorArray, 'You\'re not allowed to edit lock fields, Please contact admin');
            }
        }
    }


    /**
     * @param      $postData
     * @param      $request
     * @param User $UserEntity
     *
     * when saving custom field data,
     * We've to seprate some field.
     *
     * @return array|string
     */
    public function validateAndUpdateCustomFieldData_part1($postData, $request, User $UserEntity)
    {

        ## sort field according to custom field ID.
        ## separate custom fields from the other fields.
        ## this is only checking POST array.
        foreach ($postData as $key => $value) {

            ## find an array keys which has _ character.
            ## radio and checkbox field having this situation.
            ## i''ve did these because these fields will have multiple options so I need to insert them in the string form.
            if (strpos($key, '_')) {

                ## if we found an _ character then make it array and extract the custom field id
                ## first element of array will be the id of custom field.
                ## second element of array will be the type of the field.
                $temp_ar = explode('_', $key);

                ## if field type is radio then get the single value.
                if ($temp_ar[1] == 'checkbox') {

                    ## remove then default checked value.
                    if (array_search('__ignore___', $value)) {
                        unset($value [array_search('__ignore___', $value)]);
                    }

                    ## add to the array.
                    $temp_ar2 = [$temp_ar[0] => '**checkbox***'.implode(',', $value)];
                    $postData->add($temp_ar2);
                } else {
                    if ($temp_ar[1] == 'radio') {

                        if (array_search('__ignore___', $value)) {
                            ## remove then default checked value.
                            unset($value [array_search('__ignore___', $value)]);
                        }

                        ## add to the array.
                        $temp_ar2 = [$temp_ar[0] => '**radio***'.implode(',', $value)];
                        $postData->add($temp_ar2);
                    }
                }


                ## validate a field is this field is require or not.
                $this->validateCustomFields($key, $value);

                ## remove that key which've underscore.
                $postData->remove($key);

            } else {
                if (is_integer($key)) {
                    ## these are normal fields means will have no multiple answers., text field,
                    $this->validateCustomFields($key, $value);
                }
            }

            ## validate is this user is allowed to edit this custom field or not.
            $this->validateUserCanEditCustomFieldOrNot($key, $UserEntity->getId());
        }

        ## Validating $_FILES array.
        if (!empty($request->files)) {
            ## if user selected some files to upload
            foreach ($request->files as $key => $value) {

                /** @var CustomFields $customFieldObject */
                $customFieldObject = $this->custom_fields_repository->find($key);

                ## if empty and required.
                if ($customFieldObject->getis_require() && empty($value)) {
                    array_push($this->errorArray, 'Please upload, '.$customFieldObject->getlabel());
                }

                ## validate if user can edit this field or not.
                $this->validateUserCanEditCustomFieldOrNot($customFieldObject->getId(), $UserEntity->getId());

                ## validate allowed extensions.
                if (!empty($value)) {

                    $allowedExtensions = explode(',', $customFieldObject->getAllowedExtension());
                    try {
                        if (!in_array($value->guessExtension(), $allowedExtensions)) {
                            array_push(
                                $this->errorArray,
                                'This file extension is not allowed, Allowed extension are '.$customFieldObject->getAllowedExtension(
                                )
                            );
                        }
                    } catch (\Exception $exception) {
                        array_push($this->errorArray, $exception->getMessage());
                    }

                }
            }
        }

        ## sent errors if we've it.
        if (!empty($this->errorArray)) {
            return $this->errorArray;
        }

        ## separate custom field from the user's table.
        foreach ($postData as $key => $value) {
            ## if answer of given question is empty then remvoe the question from array.
            if (empty($value)) {
                continue;
            }

            if (is_numeric($key)) {

                /**
                 * @var CustomFields
                 * */
                $CustomFieldObject = $this->custom_fields_repository->findOneBy(['id' => $key]);

                //$this->custom_fields->getSAnswersRegardingCFs();
                //dump( $CustomFieldObject->getSAnswersRegardingCFs() );

                ## Check where to save custom field data of user.
                ## to do this first, check the user category
                if ($UserEntity->getCategory() == 's') {


                    ## fetch student entity
                    /** @var CustomFields $Entity */
                    $Entity = $this->s_answers_regarding_CF_repository->getTheFieldAnswer($key, $UserEntity->getId());

                    if (!$Entity instanceof SAnswersRegardingCF) {
                        $Entity = new SAnswersRegardingCF();
                    }

                    $Entity->setAnswers($value);
                    $Entity->setCustomFields($CustomFieldObject);
                    $Entity->setUser($UserEntity);

                } elseif ($UserEntity->getCategory() == 't') {

                    ## fetch teacher entity
                    $Entity = $this->t_answer_regarding_CF_repository->getTheFieldAnswer($key, $UserEntity->getId());

                    if (!$Entity instanceof TAnswerRegardingCF) {
                        $Entity = new TAnswerRegardingCF();
                    }
                    $Entity->setAnswers($value);
                    $Entity->setCustomFields($CustomFieldObject);
                    $Entity->setUser($UserEntity);

                } elseif ($UserEntity->getCategory() == 'a') {

                    ## fetch admin entity
                    $Entity = $this->a_answer_regarding_CF_repository->getTheFieldAnswer($key, $UserEntity->getId());

                    if (!$Entity instanceof AAnswerRegardingCF) {
                        $Entity = new AAnswerRegardingCF();
                    }

                    $Entity->setAnswers($value);
                    $Entity->setCustomFields($CustomFieldObject);
                    $Entity->setUser($UserEntity);
                }

                ## return an error.
                try {
                    ## save answer to the database
                    $this->DoctrineManger->persist($Entity);
                    ## save changes.
                    $this->DoctrineManger->flush();
                } catch (\Exception $exception) {
                    return $exception->getMessage();
                }

            }
        }

        ## file's array.
        ## if files array is not empty
        if (!empty($request->files)) {

            ## upload settings.
            $temp_ar = [
                ## upload privately
                'public' => true,
            ];

            ## run the loop
            foreach ($request->files as $key => $value) {

                /** @var CustomFields $customFieldObject */
                $customFieldObject = $this->custom_fields_repository->find($key);

                ## sent allowed extensions.
                $temp_ar['allowedExtension'] = explode(',', $customFieldObject->getAllowedExtension());
                ## path of the upload file.
                $temp_ar['path'] = 'custom_fields'.DIRECTORY_SEPARATOR.$UserEntity->getId(
                    ).DIRECTORY_SEPARATOR.$key.DIRECTORY_SEPARATOR;
                ## uploaded file.
                $temp_ar['fileArray'] = $value;
                $temp_ar['deleteFolder'] = true;
                $this->file_managment->uploadFile($temp_ar);
            }
        }
    }

    /**
     * Parse Custom field data.
     * @param $variable
     * @param $typeOfField
     * @return array
     */
    public function parseCustomFieldData($variable, $typeOfField)
    {
        $ar = [
            '**'.$typeOfField.'***' => '',
        ];

        $variable = strtr($variable, $ar);

        return explode(',', $variable);

    }


}
