<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\AssesmentRepository")
 */
class Assesment
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=70)
     */
    private $assesment_name;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $description;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $till_validate;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="assesments")
     * @ORM\JoinColumn(nullable=false)
     */
    private $assesment_class;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="assesments")
     */
    private $assessment_subject;

    /**
     * @ORM\Column(type="boolean")
     */
    private $show_to_student_guardians;

    /**
     * @ORM\Column(type="boolean")
     */
    private $show_to_class_owner_teacher;

    /**
     * @ORM\Column(type="boolean")
     */
    private $show_to_class_subject_student;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAssesmentName(): ?string
    {
        return $this->assesment_name;
    }

    public function setAssesmentName(string $assesment_name): self
    {
        $this->assesment_name = $assesment_name;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getTillValidate(): ?\DateTimeInterface
    {
        return $this->till_validate;
    }

    public function setTillValidate(?\DateTimeInterface $till_validate): self
    {
        $this->till_validate = $till_validate;

        return $this;
    }

    public function getAssesmentClass(): ?Classes
    {
        return $this->assesment_class;
    }

    public function setAssesmentClass(?Classes $assesment_class): self
    {
        $this->assesment_class = $assesment_class;

        return $this;
    }

    public function getAssessmentSubject(): ?ClassSubject
    {
        return $this->assessment_subject;
    }

    public function setAssessmentSubject(?ClassSubject $assessment_subject): self
    {
        $this->assessment_subject = $assessment_subject;

        return $this;
    }

    public function getShowToStudentGuardians(): ?bool
    {
        return $this->show_to_student_guardians;
    }

    public function setShowToStudentGuardians(bool $show_to_student_guardians): self
    {
        $this->show_to_student_guardians = $show_to_student_guardians;

        return $this;
    }

    public function getShowToClassOwnerTeacher(): ?bool
    {
        return $this->show_to_class_owner_teacher;
    }

    public function setShowToClassOwnerTeacher(bool $show_to_class_owner_teacher): self
    {
        $this->show_to_class_owner_teacher = $show_to_class_owner_teacher;

        return $this;
    }

    public function getShowToClassSubjectStudent(): ?bool
    {
        return $this->show_to_class_subject_student;
    }

    public function setShowToClassSubjectStudent(bool $show_to_class_subject_student): self
    {
        $this->show_to_class_subject_student = $show_to_class_subject_student;

        return $this;
    }
}
