<?php


namespace App\Service\SMSGateways;


use App\Entity\SMSGateways;

abstract class SMSGateWayInterface {

	/**
	 * @param SMSGateways $SMSGateways
	 *
	 * @param array       $assets
	 *
	 * @return mixed
	 * PURPOSE: Send Message to the user
	 */
	abstract function sendMessage( SMSGateways $SMSGateways, array $assets );

	/**
	 * @param SMSGateways $SMSGateways
	 *
	 * @return mixed
	 * PURPOSE: Get SMS Api
	 */
	public function getApiKey( SMSGateways $SMSGateways ) {
		$returnResponse = null;
		if ( ! empty( $SMSGateways->getSmsGwAuthorToken() ) ) {
			$returnResponse = $SMSGateways->getSmsGwAuthorToken();
		}

		return $returnResponse;
	}


	/**
	 * @param SMSGateways $SMSGateways
	 * Get the end point where we want to send request.
	 *
	 * @return string
	 */
	public function endPoints( SMSGateways $SMSGateways ) {
		$returnResponse = null;
		if ( ! empty( $SMSGateways->getEndPoint() ) ) {
			$returnResponse = $SMSGateways->getEndPoint();
		}

		return $returnResponse;
	}


	/**
	 * @param $phoneNumber
	 * Validating Phone Number
	 *
	 * @return string|null
	 */
	public function validatePhoneNumber( $phoneNumber ) {
		$returnResponse = null;
		if ( ! empty( $phoneNumber ) ) {
			$returnResponse = strtr( $phoneNumber, [
				'+' => '',
				' ' => '',
			] );
		}

		return $returnResponse;
	}


	/**
	 * @param             $message
	 *
	 * @param SMSGateways $SMSGateways
	 *
	 * @return string|null
	 */
	public function validateMessage( $message, SMSGateways $SMSGateways ) {
		$returnResponse = null;
		if ( ! empty( $message ) ) {
			$returnResponse = $SMSGateways->getSmsGwHeader() . $message . $SMSGateways->getSmsGwFooter();
		}

		return $returnResponse;
	}

}