<?php


namespace App\Service\SMSGateways;


use App\Entity\SMSGateways;
use App\Service\AppSettings;
use Symfony\Component\HttpClient\CurlHttpClient;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

class CreativeONSMS extends SMSGateWayInterface {

	/**
	 * @inheritDoc
	 * @throws TransportExceptionInterface
	 */
	public function sendMessage( SMSGateways $SMSGateways, array $assets ) {
		## api key e.g account, auth token,
		$apiKey = $this->getApiKey( $SMSGateways );
		## get end point where we want to send a request.
		$endPoint = $this->endPoints( $SMSGateways );
		## Phone number
		$phoneNumber = $this->validatePhoneNumber( $assets['receiver'] );
		## message that you want to send
		$message = $this->validateMessage( $assets['message'], $SMSGateways );

		if ( ! $apiKey || ! $endPoint ) {
			## if some of them is empty..
			return 'Api Key or End points are missing';
		}

		if ( ! $phoneNumber || ! $message ) {
			## if number or messages are not validate
			return 'receiver or message is missing';
		}

		## end point to send the message from system..
		return $endPoint = $endPoint . '?api=' . $apiKey . '&to=' . $phoneNumber . '&message=' . $message;

		$client   = HttpClient::create();
		$response = $client->request( 'GET', $endPoint );
		try {
			$response = $response->getContent();
		} catch ( ClientExceptionInterface $e ) {
		} catch ( RedirectionExceptionInterface $e ) {
		} catch ( ServerExceptionInterface $e ) {
		} catch ( TransportExceptionInterface $e ) {
			$response = $e->getMessage();
		}

		return $response;
	}

	/**
	 * @inheritDoc
	 */
	//	public function getApiKey( SMSGateways $SMSGateways ) {
	//		return trim( $SMSGateways->getSmsGwAuthorToken() );
	//	}


	//	public function endPoints( SMSGateways $SMSGateways ) {
	//		return trim( $SMSGateways->getEndPoint() );
	//	}
}
