<?php

namespace App\Repository;

use App\Entity\Transactions;
use App\Service\DefaultFunction;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\DBAL\DBALException;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method Transactions|null find( $id, $lockMode = null, $lockVersion = null )
 * @method Transactions|null findOneBy( array $criteria, array $orderBy = null )
 * @method Transactions[]    findAll()
 * @method Transactions[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class TransactionsRepository extends ServiceEntityRepository {

	/**
	 * @var DefaultFunction
	 */
	private $default_function;

	public function __construct( DefaultFunction $default_function, RegistryInterface $registry ) {
		parent::__construct( $registry, Transactions::class );
		$this->default_function = $default_function;
	}


	## get the transaction amount regarding the invoice
	## when user want to pay his invoice then system will check is this invoice is already paid or not
	## if paid so, who much user has paid for this invoice.
	public function count__transaction_amount_regariding__invoice( int $invId ) {
		try {
			return $this->createQueryBuilder( 'transactions' )
			            ->select( 'SUM(transactions.amount) as transaction_total_amount' )
			            ->where( 'transactions.invoice_reference = :inv' )
			            ->setParameter( 'inv', $invId )
			            ->getQuery()
			            ->getSingleScalarResult();
		} catch ( NonUniqueResultException $e ) {
			return $e->getMessage();
		}
	}

	public function transactionQueryBuilder() {
		return $this->createQueryBuilder( 'transactions' );
	}

	## 1 or expense and 0 for the income
	public function calculateIncomeOrExpenseAmount( $isExpenseOrIncome ) {
		try {
			$result = $this->transactionQueryBuilder()
			               ->select( 'SUM(transactions.amount)' )
			               ->where( 'transactions.is_expense_or_income = :is_expense_or_income' )
			               ->setParameter( 'is_expense_or_income', $isExpenseOrIncome )
			               ->getQuery()
			               ->getSingleScalarResult();
		} catch ( \Exception $exception ) {
			$result = 0;
		}

		return $result;
	}

	/**
	 * Advance Search
	 * */
	public function advanceSearch( ParameterBag $bag ) {
		$queryBuilder = $this->createQueryBuilder( 'transactions' );

		## Income or expense Transaction
		if ( $bag->get( 'is_expense_or_income' ) == 1 || $bag->get( 'is_expense_or_income' ) == 2 ) {
			$queryBuilder->andWhere( 'transactions.is_expense_or_income = :ExpenseOrIncome' )
			             ->setParameter( 'ExpenseOrIncome', $this->default_function->parse__boolean( $bag->get( 'is_expense_or_income' ) ) );
		}

		## Search by transaction description.
		if ( ! empty( $bag->get( 'trans_description' ) ) ) {
			$queryBuilder->andWhere( 'transactions.id = :transRef' )
			             ->setParameter( 'transRef', $bag->get( 'trans_description' ) );
		}

		##Search by transaction id
		if ( ! empty( $bag->get( 'trans_id' ) ) ) {
			$queryBuilder->andWhere( 'transactions = :transRef_' )
			             ->setParameter( 'transRef_', $bag->get( 'trans_id' ) );
		}

		## Date Range.
		## transaction from this date to that date
		if ( ! empty( $bag->get( 'transactionDateRange' ) ) ) {

			## Convert string into an array
			$attendanceDate = explode( ' / ', $bag->get( 'transactionDateRange' ) );

			## if array is created and duration date is exits then search in database
			if ( is_array( $attendanceDate ) && ! empty( $attendanceDate[0] && ! empty( $attendanceDate[1] ) ) ) {
				## InTime Search
				## used in the duration
				$queryBuilder->andWhere( 'transactions.trans_datetime BETWEEN :transFrom and :transTo' );
				$queryBuilder->setParameter( 'transFrom', date( 'Y-m-d', strtotime( trim( $attendanceDate[0] ) ) ) . '%' );
				$queryBuilder->setParameter( 'transTo', date( 'Y-m-d', strtotime( trim( $attendanceDate[1] ) ) ) . '%' );
			}

		}

		## Transaction amount
		if ( ! empty( $bag->get( 'trans_amount_id' ) ) ) {
			$queryBuilder->andWhere( 'transactions.id = :transAmountRef' )
			             ->setParameter( 'transAmountRef', $bag->get( 'trans_amount_id' ) );
		}


		## Search by payment method
		if ( ! empty( $bag->get( 'payment_method' ) ) ) {
			$queryBuilder->andWhere( 'transactions.payment_method_reference = :paymentMethodReference' )
			             ->setParameter( 'paymentMethodReference', $bag->get( 'payment_method' ) );
		}

		## Search registerUser
		if ( ! empty( $bag->get( 'registerUser' ) ) ) {
			$queryBuilder->andWhere( 'transactions.trans_paid_to = :registerUser' )
			             ->setParameter( 'registerUser', $bag->get( 'registerUser' ) );
		}

		## search for account or income head and expense head
		if ( ! empty( $bag->get( 'account_head' ) ) ) {
			$queryBuilder->andWhere( 'transactions.income_head = :incomeHeadReference' )
			             ->setParameter( 'incomeHeadReference', $bag->get( 'account_head' ) );
		}

		## Search for un-register user
		if ( ! empty( $bag->get( 'unRegisterUser' ) ) ) {
			$queryBuilder->andWhere( 'transactions.id = :UnregisterUser' )
			             ->setParameter( 'UnregisterUser', $bag->get( 'unRegisterUser' ) );
		}

		return $queryBuilder->getQuery()->getResult();
	}

	// get last two month reports.
	public function last10MonthReport($incomeOrExpense = 1){
	    // 0 mean expense
        // 1 means income
	    $sql = "
	    
	   SELECT CONCAT(Month(days.day), ' - ', Year(days.day)) as datee,  SUM(transactions.amount)  as amount
            FROM
              (select curdate() as day
               union select curdate() - interval 1 Month
               union select curdate() - interval 2 Month
               union select curdate() - interval 3 Month
               union select curdate() - interval 4 Month
               union select curdate() - interval 5 Month
               union select curdate() - interval 6 Month
               union select curdate() - interval 7 Month
               union select curdate() - interval 8 Month
               union select curdate() - interval 9 Month
              ) days
              left join (select * from transactions where transactions.is_expense_or_income= {$incomeOrExpense}) transactions
               on Month(days.day) = Month(transactions.trans_datetime) and Year(days.day) = Year(transactions.trans_datetime)
            group by
              days.day
	    
	    ";

        try {
            $stmt = $this->getEntityManager()->getConnection()->prepare($sql);
            $stmt->execute();
            return $stmt->fetchAll();
        } catch (DBALException $e) {
            return $e->getMessage();
        }
    }
}
