<?php

namespace App\Repository;

use App\Entity\EmailTemplates;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method EmailTemplates|null find( $id, $lockMode = null, $lockVersion = null )
 * @method EmailTemplates|null findOneBy( array $criteria, array $orderBy = null )
 * @method EmailTemplates[]    findAll()
 * @method EmailTemplates[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class EmailTemplatesRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, EmailTemplates::class );
	}

	public function role_based_template() {
		return $this->createQueryBuilder( 'email_templates' )
		            ->indexBy( 'email_templates', 'email_templates.assigned_to' )
		            ->getQuery()
		            ->getResult();
	}


	// /**
	//  * @return EmailTemplates[] Returns an array of EmailTemplates objects
	//  */
	/*
	public function findByExampleField($value)
	{
		return $this->createQueryBuilder('e')
			->andWhere('e.exampleField = :val')
			->setParameter('val', $value)
			->orderBy('e.id', 'ASC')
			->setMaxResults(10)
			->getQuery()
			->getResult()
		;
	}
	*/

	/*
	public function findOneBySomeField($value): ?EmailTemplates
	{
		return $this->createQueryBuilder('e')
			->andWhere('e.exampleField = :val')
			->setParameter('val', $value)
			->getQuery()
			->getOneOrNullResult()
		;
	}
	*/
}
