<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\LibraryBookCopiesRepository")
 */
class LibraryBookCopies {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="smallint")
	 */
	private $bc_no;

	/**
	 * @ORM\Column(type="smallint")
	 */
	private $bc_condition_rating;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\BooksLibrary", inversedBy="libraryBookCopies")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $library_book_ref;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\LibraryAssigned", mappedBy="library_book_copies_ref")
	 */
	private $libraryAssigneds;

	/**
	 * @ORM\Column(type="boolean", nullable=true)
	 */
	private $is_occpuied = 0;

	public function __construct() {
		$this->libraryAssigneds = new ArrayCollection();
	}

	public function getId(): ?int {
		return $this->id;
	}

	public function getBcNo(): ?int {
		return $this->bc_no;
	}

	public function setBcNo( int $bc_no ): self {
		$this->bc_no = $bc_no;

		return $this;
	}

	public function getBcConditionRating(): ?int {
		return $this->bc_condition_rating;
	}

	public function setBcConditionRating( int $bc_condition_rating ): self {
		$this->bc_condition_rating = $bc_condition_rating;

		return $this;
	}

	public function getLibraryBookRef(): ?BooksLibrary {
		return $this->library_book_ref;
	}

	public function setLibraryBookRef( ?BooksLibrary $library_book_ref ): self {
		$this->library_book_ref = $library_book_ref;

		return $this;
	}

	/**
	 * @return Collection|LibraryAssigned[]
	 */
	public function getLibraryAssigneds(): Collection {
		return $this->libraryAssigneds;
	}

	public function addLibraryAssigned( LibraryAssigned $libraryAssigned ): self {
		if ( ! $this->libraryAssigneds->contains( $libraryAssigned ) ) {
			$this->libraryAssigneds[] = $libraryAssigned;
			$libraryAssigned->setLibraryBookCopiesRef( $this );
		}

		return $this;
	}

	public function removeLibraryAssigned( LibraryAssigned $libraryAssigned ): self {
		if ( $this->libraryAssigneds->contains( $libraryAssigned ) ) {
			$this->libraryAssigneds->removeElement( $libraryAssigned );
			// set the owning side to null (unless already changed)
			if ( $libraryAssigned->getLibraryBookCopiesRef() === $this ) {
				$libraryAssigned->setLibraryBookCopiesRef( null );
			}
		}

		return $this;
	}

	public function getIsOccpuied(): ?bool {
		return $this->is_occpuied;
	}

	public function setIsOccpuied( ?bool $is_occpuied ): self {
		$this->is_occpuied = $is_occpuied;

		return $this;
	}
}
