<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass="App\Repository\CustomFieldsRepository")
 */
class CustomFields {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=50, name="label")
	 * @Assert\NotBlank(message="Please type Field Label")
	 */
	private $label;

	/**
	 * @ORM\Column(type="string", length=20, name="type")
	 * @Assert\NotBlank(message="Please select field type")
	 */
	private $type;

	/**
	 * @ORM\Column(type="boolean", nullable=true, name="is_require")
	 *
	 */
	private $is_require;

	/**
	 * @ORM\Column(type="string", length=100, nullable=true, name="placeholder")
	 */
	private $placeholder;


	/**
	 * @ORM\Column(type="array", nullable=true, name="options")
	 *
	 * PURPOSE: If we choose dropdown or radio type input then we've to show some value in it.
	 * In the dropdown we've multiple options & also in the radio type input.
	 */
	private $options = [];

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\SAnswersRegardingCF", mappedBy="CustomFields", orphanRemoval=true)
	 */
	private $sAnswersRegardingCFs;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\TAnswerRegardingCF", mappedBy="CustomFields",orphanRemoval=true)
	 */
	private $tAnswerRegardingCFs;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\AAnswerRegardingCF", mappedBy="CustomFields",orphanRemoval=true)
	 */
	private $aAnswerRegardingCFs;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true, name="visible_to")
	 */
	private $visible_to;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $visible_to_registration_form_of;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $allowed_extension;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\CustomFieldSections", inversedBy="custom_field_ref")
	 * @ORM\JoinColumn()
	 */
	private $customFieldSections;

	/**
	 * @ORM\ManyToMany(targetEntity="App\Entity\WhoCanUpdateCustomField", mappedBy="custom_field_ref")
	 */
	private $whoCanUpdateCustomFields;

	/**
	 * @ORM\Column(type="integer", nullable=true)
	 */
	private $sorting_order;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $help_message;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

	public function __construct() {
         		$this->sAnswersRegardingCFs     = new ArrayCollection();
         		$this->tAnswerRegardingCFs      = new ArrayCollection();
         		$this->aAnswerRegardingCFs      = new ArrayCollection();
         		$this->whoCanUpdateCustomFields = new ArrayCollection();
         	}

	public function getId(): ?int {
         		return $this->id;
         	}

	public function getlabel(): ?string {
         		return $this->label;
         	}

	public function setlabel( string $fLabel ): self {
         		$this->label = $fLabel;
         
         		return $this;
         	}

	public function gettype(): ?string {
         		return $this->type;
         	}

	public function settype( string $fType ): self {
         		$this->type = $fType;
         
         		return $this;
         	}

	public function getis_require(): ?bool {
         		return $this->is_require;
         	}

	public function setis_require( ?bool $fIsRequire ): self {
         		$this->is_require = $fIsRequire;
         
         		return $this;
         	}

	public function getplaceholder(): ?string {
         		return $this->placeholder;
         	}

	public function setplaceholder( ?string $fPlaceholder ): self {
         		$this->placeholder = $fPlaceholder;
         
         		return $this;
         	}

	public function getoptions(): ?array {
         		return $this->options;
         	}

	public function setoptions( ?array $fFieldOptions ): self {
         		$this->options = $fFieldOptions;
         
         		return $this;
         	}

	/**
	 * @return Collection|SAnswersRegardingCF[]
	 */
	public function getSAnswersRegardingCFs(): Collection {
         		return $this->sAnswersRegardingCFs;
         	}

	public function addSAnswersRegardingCF( SAnswersRegardingCF $sAnswersRegardingCF ): self {
         		if ( ! $this->sAnswersRegardingCFs->contains( $sAnswersRegardingCF ) ) {
         			$this->sAnswersRegardingCFs[] = $sAnswersRegardingCF;
         			$sAnswersRegardingCF->setCustomFields( $this );
         		}
         
         		return $this;
         	}

	public function removeSAnswersRegardingCF( SAnswersRegardingCF $sAnswersRegardingCF ): self {
         		if ( $this->sAnswersRegardingCFs->contains( $sAnswersRegardingCF ) ) {
         			$this->sAnswersRegardingCFs->removeElement( $sAnswersRegardingCF );
         			// set the owning side to null (unless already changed)
         			if ( $sAnswersRegardingCF->getCustomFields() === $this ) {
         				$sAnswersRegardingCF->setCustomFields( null );
         			}
         		}
         
         		return $this;
         	}

	/**
	 * @return Collection|TAnswerRegardingCF[]
	 */
	public function getTAnswerRegardingCFs(): Collection {
         		return $this->tAnswerRegardingCFs;
         	}

	public function addTAnswerRegardingCF( TAnswerRegardingCF $tAnswerRegardingCF ): self {
         		if ( ! $this->tAnswerRegardingCFs->contains( $tAnswerRegardingCF ) ) {
         			$this->tAnswerRegardingCFs[] = $tAnswerRegardingCF;
         			$tAnswerRegardingCF->setCustomFields( $this );
         		}
         
         		return $this;
         	}

	public function removeTAnswerRegardingCF( TAnswerRegardingCF $tAnswerRegardingCF ): self {
         		if ( $this->tAnswerRegardingCFs->contains( $tAnswerRegardingCF ) ) {
         			$this->tAnswerRegardingCFs->removeElement( $tAnswerRegardingCF );
         			// set the owning side to null (unless already changed)
         			if ( $tAnswerRegardingCF->getCustomFields() === $this ) {
         				$tAnswerRegardingCF->setCustomFields( null );
         			}
         		}
         
         		return $this;
         	}

	/**
	 * @return Collection|AAnswerRegardingCF[]
	 */
	public function getAAnswerRegardingCFs(): Collection {
         		return $this->aAnswerRegardingCFs;
         	}

	public function addAAnswerRegardingCF( AAnswerRegardingCF $aAnswerRegardingCF ): self {
         		if ( ! $this->aAnswerRegardingCFs->contains( $aAnswerRegardingCF ) ) {
         			$this->aAnswerRegardingCFs[] = $aAnswerRegardingCF;
         			$aAnswerRegardingCF->setCustomFields( $this );
         		}
         
         		return $this;
         	}

	public function removeAAnswerRegardingCF( AAnswerRegardingCF $aAnswerRegardingCF ): self {
         		if ( $this->aAnswerRegardingCFs->contains( $aAnswerRegardingCF ) ) {
         			$this->aAnswerRegardingCFs->removeElement( $aAnswerRegardingCF );
         			// set the owning side to null (unless already changed)
         			if ( $aAnswerRegardingCF->getCustomFields() === $this ) {
         				$aAnswerRegardingCF->setCustomFields( null );
         			}
         		}
         
         		return $this;
         	}

	public function getVisibleTo(): ?string {
         		return $this->visible_to;
         	}

	public function setVisibleTo( ?string $visible_to ): self {
         		$this->visible_to = $visible_to;
         
         		return $this;
         	}

	public function getVisibleToRegistrationFormOf(): ?string {
         		return $this->visible_to_registration_form_of;
         	}

	public function setVisibleToRegistrationFormOf( ?string $visible_to_registration_form_of ): self {
         		$this->visible_to_registration_form_of = $visible_to_registration_form_of;
         
         		return $this;
         	}

	public function getAllowedExtension(): ?string {
         		return $this->allowed_extension;
         	}

	public function setAllowedExtension( ?string $allowed_extension ): self {
         		$this->allowed_extension = $allowed_extension;
         
         		return $this;
         	}


	/**
	 * @return Collection|WhoCanUpdateCustomField[]
	 */
	public function getWhoCanUpdateCustomFields(): Collection {
         		return $this->whoCanUpdateCustomFields;
         	}

	public function addWhoCanUpdateCustomField( WhoCanUpdateCustomField $whoCanUpdateCustomField ): self {
         		if ( ! $this->whoCanUpdateCustomFields->contains( $whoCanUpdateCustomField ) ) {
         			$this->whoCanUpdateCustomFields[] = $whoCanUpdateCustomField;
         			$whoCanUpdateCustomField->addCustomFieldRef( $this );
         		}
         
         		return $this;
         	}

	public function removeWhoCanUpdateCustomField( WhoCanUpdateCustomField $whoCanUpdateCustomField ): self {
         		if ( $this->whoCanUpdateCustomFields->contains( $whoCanUpdateCustomField ) ) {
         			$this->whoCanUpdateCustomFields->removeElement( $whoCanUpdateCustomField );
         			$whoCanUpdateCustomField->removeCustomFieldRef( $this );
         		}
         
         		return $this;
         	}

	/**
	 * @return mixed
	 */
	public function getCustomFieldSections() {
         		return $this->customFieldSections;
         	}

	/**
	 * @param mixed $customFieldSections
	 */
	public function setCustomFieldSections( $customFieldSections ): void {
         		$this->customFieldSections = $customFieldSections;
         	}

	public function getSortingOrder(): ?int {
         		return $this->sorting_order;
         	}

	public function setSortingOrder( ?int $sorting_order ): self {
         		$this->sorting_order = $sorting_order;
         
         		return $this;
         	}

	public function getHelpMessage(): ?string {
         		return $this->help_message;
         	}

	public function setHelpMessage( ?string $help_message ): self {
         		$this->help_message = $help_message;
         
         		return $this;
         	}

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
