<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\AllocateTeacherToClassAndSubjectsRepository")
 */
class AllocateTeacherToClassAndSubjects
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="allocateTeacherToClassAndSubjects")
     * @ORM\JoinColumn(nullable=false)
     */
    private $teacher;

    /**
     * @ORM\Column(type="datetime")
     */
    private $assign_from_date;

    /**
     * @ORM\Column(type="datetime")
     */
    private $assign_to_date;

    ##   * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="class_subject")
    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="class")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="allocateTeacherToClassAndSubjects")
     * @ORM\JoinColumn(nullable=true)
     */
    private $class_subject;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = 0;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTeacher(): ?User
    {
        return $this->teacher;
    }

    public function setTeacher(?User $teacher): self
    {
        $this->teacher = $teacher;

        return $this;
    }

    public function getAssignFromDate(): ?\DateTimeInterface
    {
        return $this->assign_from_date;
    }

    public function setAssignFromDate(\DateTimeInterface $assign_from_date): self
    {
        $this->assign_from_date = $assign_from_date;

        return $this;
    }

    public function getAssignToDate(): ?\DateTimeInterface
    {
        return $this->assign_to_date;
    }

    public function setAssignToDate(\DateTimeInterface $assign_to_date): self
    {
        $this->assign_to_date = $assign_to_date;

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->class_subject;
    }

    public function setClassSubject(?ClassSubject $class_subject): self
    {
        $this->class_subject = $class_subject;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
