<?php

namespace App\DataFixtures;

use App\Entity\ShortEmailTemplates;
use App\Service\Constants;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;
use Gedmo\Translatable\Translatable;

class ShortEmailTemplatesFixture extends Fixture implements DependentFixtureInterface {


	private $faker;

	public function load( ObjectManager $manager ) {


		$this->faker = Factory::create();

		for ( $x = 0; $x < 10; $x ++ ) {
			$ShortEmailTemplate = new ShortEmailTemplates();
			$ShortEmailTemplate->setEmailTemplateRefer( $this->getReference( EmailTemplateFixtures::EMAIL_TEMPLATE_REFERENCE . '_' . $x ) );
			$ShortEmailTemplate->setContent( $this->faker->text( 5 ) );
			$temp_array = [
				's_name',
				't_name',
				'a_name',
				'g_name',
				's_admission_number',
			];
			$ShortEmailTemplate->setVariables( $temp_array );
			$ShortEmailTemplate->setCreatedAt( $this->faker->dateTime( 'now' ) );
			$ShortEmailTemplate->setUpdatedAt( $this->faker->dateTime( 'now' ) );
			$ShortEmailTemplate->setIsActive( $this->faker->boolean( 50 ) );
			$manager->persist( $ShortEmailTemplate );


			## save multilang email templates.
			/** @var Translatable */
			$repository__d = $manager->getRepository( 'Gedmo\\Translatable\\Entity\\Translation' );

			foreach ( Constants::SupportedLanguages as $key => $value ) {
				$repository__d->translate( $ShortEmailTemplate, 'content', $key, 'Short Messages Translate in ' . $value );
			}

		}


		// $product = new Product();
		// $manager->persist($product);

		$manager->flush();
	}

	/**
	 * This method must return an array of fixtures classes
	 * on which the implementing class depends on
	 *
	 * @return array
	 */
	public function getDependencies() {
		// TODO: Implement getDependencies() method.
		return [
			EmailTemplateFixtures::class,
		];
	}
}
