<?php

namespace App\Controller;

use App\Entity\InventoryCategory;
use App\Entity\InvtStockItems;
use App\Repository\InventoryCategoryRepository;
use App\Repository\InventoryItemsUsageRepository;
use App\Repository\InventoryStockLocationRepository;
use App\Repository\InventoryStockRepository;
use App\Repository\InvtStockItemsRepository;
use App\Service\SchoolInventoryService;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class SchoolInventoryController extends AbstractController {

	/**
	 * @var InventoryCategoryRepository
	 */
	private $inventory_category_repository;
	/**
	 * @var SchoolInventoryService
	 */
	private $school_inventory_service;
	/**
	 * @var InventoryStockLocationRepository
	 */
	private $inventory_stock_location_repository;
	/**
	 * @var InventoryStockRepository
	 */
	private $inventory_stock_repository;
	/**
	 * @var InvtStockItemsRepository
	 */
	private $invt_stock_items_repository;
	/**
	 * @var InventoryItemsUsageRepository
	 */
	private $inventory_items_usage_repository;

	public function __construct( InventoryCategoryRepository $inventory_category_repository, SchoolInventoryService $school_inventory_service, InventoryStockLocationRepository $inventory_stock_location_repository, InventoryStockRepository $inventory_stock_repository, InvtStockItemsRepository $invt_stock_items_repository, InventoryItemsUsageRepository $inventory_items_usage_repository ) {
		$this->inventory_category_repository       = $inventory_category_repository;
		$this->school_inventory_service            = $school_inventory_service;
		$this->inventory_stock_location_repository = $inventory_stock_location_repository;
		$this->inventory_stock_repository          = $inventory_stock_repository;
		$this->invt_stock_items_repository         = $invt_stock_items_repository;
		$this->inventory_items_usage_repository    = $inventory_items_usage_repository;
	}


	/**
	 * @Route("{_locale}/school/inventory/cateogry", name="school_inventory_category")
	 */
	public function inventory___add__category() {
		return $this->render( 'school_inventory/inventory__cateogry.html.twig', [
			'category_list' => $this->inventory_category_repository->findAll(),
		] );
	}


	/**
	 * @Route("{_locale}/school/inventory/stock", name="school_inventory_stock")
	 */
	public function inventory___add__stock() {
		return $this->render( 'school_inventory/inventory__stock.html.twig', [
			'inventory__stock'    => $this->inventory_stock_repository->findAll(),
			'inventory__category' => $this->inventory_category_repository->findAll(),
		] );
	}


	/**
	 * @Route("{_locale}/school/inventory/stock/item", name="school_inventory_stock_item")
	 */
	public function inventory___add__stock__items() {
		return $this->render( 'school_inventory/inventory__stock__items.html.twig', [
			'inventory__stock__items'        => $this->invt_stock_items_repository->findAll(),
			'inventory__list'                => $this->inventory_stock_repository->findAll(),
			'inventory_stock_items_location' => $this->inventory_stock_location_repository->findAll(),
		] );
	}

	/**
	 * @Route("{_locale}/school/inventory/stock/item/location", name="school_inventory_stock_item_location")
	 */
	public function inventory___add__stock__items_location() {
		return $this->render( 'school_inventory/inventory__stock__items__location.html.twig', [
			'location_list' => $this->inventory_stock_location_repository->findAll(),
		] );
	}


	/**
	 * @Route("{_locale}/school/inventory/stock/item/usage-history", name="school_inventory_stock_item_usage_history")
	 */
	public function inventory___add__stock__items_usage_history() {
		return $this->render( 'school_inventory/inventory__stock__items__usage_history.html.twig', [
			'usage__list'                    => $this->inventory_items_usage_repository->findAll(),
			'inventory__stock__items'        => $this->invt_stock_items_repository->findAll(),
			'inventory__list'                => $this->inventory_stock_repository->findAll(),
			'inventory_stock_items_location' => $this->inventory_stock_location_repository->findAll(),
		] );
	}

	/**
	 * @Route("{_locale}/inventory/requestHandler", name="requestHandler_inventory")
	 * @param Request $request
	 *
	 * @return JsonResponse
	 */
	public function ajaxHandler( Request $request ) {
		$query = $request->query->get( 'query' );
		switch ( $query ) {
			case 'addNewCategory':
				//add or edit inventory category
				$returnValue = $this->school_inventory_service->add_edit_category( $request->request );
				break;
			case 'addUpdateLocation':
				//add or edit inventory items locations
				$returnValue = $this->school_inventory_service->add_edit_location( $request->request );
				break;
			case 'add__inv__stox':
				//add or edit inventory stock
				$returnValue = $this->school_inventory_service->add_edit_inventory_stock( $request->request );
				break;
			case 'add__inv__stox__item':
				//add or edit inventory stock items.
				$returnValue = $this->school_inventory_service->add_edit_inventory_stock_item( $request->request );
				break;
			case 'add__inv__stox__item__usage__':
				//add or edit inventory stock items usage.
				$returnValue = $this->school_inventory_service->add__edit__inventory__usage( $request->request );
				break;
			Default:
				$returnValue = 'OK';
				break;
		}

		return new JsonResponse( $returnValue, '200' );
	}
}
