<?php

namespace App\Controller;

use App\Entity\Guardian;
use App\Repository\GuardianRepository;
use App\Service\Guardian\GuardianService;
use App\Service\UserService;
use Nzo\UrlEncryptorBundle\Annotations\ParamDecryptor;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class GuardianController extends AbstractController {


	/**
	 * @var GuardianService
	 */
	private $guardian_service;
	/**
	 * @var GuardianRepository
	 */
	private $guardian_repository;

	public function __construct( GuardianService $guardian_service, GuardianRepository $guardian_repository ) {
		$this->guardian_service    = $guardian_service;
		$this->guardian_repository = $guardian_repository;
	}

	/**
	 * @Route("{_locale}/guardian", name="guardian")
	 * PURPOSE: List of Guardian
	 */
	public function index() {
		return $this->render( 'guardian/listOfGuardians.html.twig', [
			'guardians' => $this->guardian_repository->findAll(),
		] );
	}

	/**
	 * @Route("{_locale}/add/guardian/{id}", name="add_guardian", defaults={"id"=null})
	 * @ParamDecryptor(params={"id"})
	 * PURPOSE: Adding guardian into database
	 * @param $id
	 * @return Response
	 */
	public function addGuardian( $id ) {
		return $this->render( 'guardian/addGuardians.html.twig', [
			'guardian' =>$this->guardian_service->getGuardian( $id )
		] );
	}


	/**
	 * @Route("{_locale}/guardian/requestHandler/remote-request/{query}", name="requestHandlerGuardian")
	 * @param Request $request
	 * @param null    $query
	 *
	 * @return JsonResponse
	 */
	public function ajaxHandler( Request $request, $query = null ) {
		## if user is not logged in the redirect th e use rto login page.
		$response = 'OK';
		if ( empty( $query ) ) {
			## get the query variable from the get request.
			$query = $request->query->get( 'query' );
		}

		switch ( $query ) {
			case 'registerGuardian':
				## register Guardian or edit Guardian
				$response = $this->guardian_service->registerGuardian( $request->request );
				break;
			case 'guardianDropdown':
				$response = 'escape__fromErro_' . $this->renderView( 'guardian/guardian__dropdown.html.twig', [
						'guardian' => $this->guardian_repository->findBy( [], [ 'id' => 'DESC' ] ),
					] );
				break;
			default:
				break;
		}

		return new JsonResponse( $response, 200 );
	}
}
